/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.ServiceDescriptor;
import org.mule.runtime.module.service.ServiceDescriptorFactory;
import org.mule.runtime.module.service.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.ServiceResolutionError;

public class FileSystemServiceProviderDiscoverer
implements ServiceProviderDiscoverer {
    private final ArtifactClassLoader apiClassLoader;
    private final ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory;
    private final DescriptorLoaderRepository descriptorLoaderRepository;

    public FileSystemServiceProviderDiscoverer(ArtifactClassLoader containerClassLoader, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory, DescriptorLoaderRepository descriptorLoaderRepository) {
        this.descriptorLoaderRepository = descriptorLoaderRepository;
        Preconditions.checkArgument(containerClassLoader != null, "containerClassLoader cannot be null");
        Preconditions.checkArgument(serviceClassLoaderFactory != null, "serviceClassLoaderFactory cannot be null");
        this.apiClassLoader = containerClassLoader;
        this.serviceClassLoaderFactory = serviceClassLoaderFactory;
    }

    @Override
    public List<Pair<ArtifactClassLoader, ServiceProvider>> discover() throws ServiceResolutionError {
        ServiceDescriptorFactory serviceDescriptorFactory = new ServiceDescriptorFactory(this.descriptorLoaderRepository);
        LinkedList<ServiceDescriptor> serviceDescriptors = new LinkedList<ServiceDescriptor>();
        serviceDescriptors.addAll(this.getLegacyServiceDescriptors(serviceDescriptorFactory));
        serviceDescriptors.addAll(this.getServiceDescriptors(serviceDescriptorFactory));
        return this.createServiceProviders(serviceDescriptors, this.serviceClassLoaderFactory);
    }

    private List<ServiceDescriptor> getLegacyServiceDescriptors(ServiceDescriptorFactory serviceDescriptorFactory) throws ServiceResolutionError {
        LinkedList<ServiceDescriptor> foundServices = new LinkedList<ServiceDescriptor>();
        for (String serviceFile : MuleFoldersUtil.getServicesFolder().list((FilenameFilter)new SuffixFileFilter(".zip"))) {
            File tempFolder = new File(MuleFoldersUtil.getServicesTempFolder(), FilenameUtils.getBaseName((String)serviceFile));
            try {
                FileUtils.unzip(new File(MuleFoldersUtil.getServicesFolder(), serviceFile), tempFolder);
            }
            catch (IOException e) {
                throw new ServiceResolutionError("Error processing service ZIP file", e);
            }
            ServiceDescriptor serviceDescriptor = serviceDescriptorFactory.create(tempFolder);
            foundServices.add(serviceDescriptor);
        }
        return foundServices;
    }

    private List<ServiceDescriptor> getServiceDescriptors(ServiceDescriptorFactory serviceDescriptorFactory) throws ServiceResolutionError {
        LinkedList<ServiceDescriptor> foundServices = new LinkedList<ServiceDescriptor>();
        for (String serviceFile : MuleFoldersUtil.getServicesFolder().list((FilenameFilter)new SuffixFileFilter(".jar"))) {
            File tempFolder = new File(MuleFoldersUtil.getServicesTempFolder(), FilenameUtils.getBaseName((String)serviceFile));
            try {
                FileUtils.unzip(new File(MuleFoldersUtil.getServicesFolder(), serviceFile), tempFolder);
            }
            catch (IOException e) {
                throw new ServiceResolutionError("Error processing service JAR file", e);
            }
            ServiceDescriptor serviceDescriptor = serviceDescriptorFactory.create(tempFolder);
            foundServices.add(serviceDescriptor);
        }
        return foundServices;
    }

    private List<Pair<ArtifactClassLoader, ServiceProvider>> createServiceProviders(List<ServiceDescriptor> serviceDescriptors, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory) throws ServiceResolutionError {
        LinkedList<Pair<ArtifactClassLoader, ServiceProvider>> serviceProviders = new LinkedList<Pair<ArtifactClassLoader, ServiceProvider>>();
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            ArtifactClassLoader serviceClassLoader = serviceClassLoaderFactory.create(this.getServiceArtifactId(serviceDescriptor), serviceDescriptor, this.apiClassLoader.getClassLoader(), this.apiClassLoader.getClassLoaderLookupPolicy());
            ServiceProvider serviceProvider = this.instantiateServiceProvider(serviceClassLoader.getClassLoader(), serviceDescriptor.getServiceProviderClassName());
            serviceProviders.add(new Pair<ArtifactClassLoader, ServiceProvider>(serviceClassLoader, serviceProvider));
        }
        return serviceProviders;
    }

    private String getServiceArtifactId(ServiceDescriptor serviceDescriptor) {
        return "service/" + serviceDescriptor.getName();
    }

    private ServiceProvider instantiateServiceProvider(ClassLoader classLoader, String className) throws ServiceResolutionError {
        Object reflectedObject;
        try {
            reflectedObject = ClassUtils.withContextClassLoader(classLoader, () -> {
                try {
                    return ClassUtils.instantiateClass(className, new Object[0]);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Unable to create service from class: " + className), (Throwable)e);
                }
            });
        }
        catch (RuntimeException e) {
            throw new ServiceResolutionError(e.getMessage());
        }
        if (!(reflectedObject instanceof ServiceProvider)) {
            throw new ServiceResolutionError(String.format("Provided service class '%s' does not implement '%s'", className, ServiceProvider.class.getName()));
        }
        return (ServiceProvider)reflectedObject;
    }
}

