/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.xml.namespace.QName;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.xml.XmlTypeLoader;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.runtime.soap.api.exception.InvalidWsdlException;
import org.mule.service.soap.introspection.WsdlDefinition;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;

final class EmptyRequestGenerator {
    private static final String REQUIRED_PARAMS_ERROR_MASK = "Cannot build default body request for operation [%s]%s, the operation requires input parameters";
    private static final String NO_PARAMS_SOAP_BODY_CALL_MASK = "<ns:%s xmlns:ns=\"%s\"/>";
    private final WsdlDefinition definition;
    private final XmlTypeLoader loader;

    public EmptyRequestGenerator(WsdlDefinition definition, XmlTypeLoader loader) {
        this.definition = definition;
        this.loader = loader;
    }

    String generateRequest(String operation) {
        BindingOperation bindingOperation = this.definition.getBindingOperation(operation);
        Optional<List<String>> soapBodyParts = this.getSoapBodyParts(bindingOperation);
        if (!soapBodyParts.isPresent()) {
            throw new InvalidWsdlException(String.format("No SOAP body defined in the WSDL for the specified operation, cannot check if the operation requires input parameters. Cannot build a default body request for the specified operation [%s]", operation));
        }
        Message message = bindingOperation.getOperation().getInput().getMessage();
        Optional<Part> part = this.getSinglePart(soapBodyParts.get(), message);
        if (!part.isPresent()) {
            throw new BadRequestException(String.format(REQUIRED_PARAMS_ERROR_MASK, operation, " there is no single part in the input message"));
        }
        if (part.get().getElementName() == null) {
            throw new BadRequestException(String.format(REQUIRED_PARAMS_ERROR_MASK, operation, " there is one message body part but no does not have an element defined"));
        }
        Part bodyPart = part.get();
        if (this.isOperationWithRequiredParameters(this.loader, bodyPart)) {
            throw new BadRequestException(String.format(REQUIRED_PARAMS_ERROR_MASK, operation, ""));
        }
        QName element = bodyPart.getElementName();
        return String.format(NO_PARAMS_SOAP_BODY_CALL_MASK, element.getLocalPart(), element.getNamespaceURI());
    }

    private boolean isOperationWithRequiredParameters(TypeLoader loader, Part part) {
        Optional<MetadataType> bodyType = loader.load(part.getElementName().toString());
        if (bodyType.isPresent()) {
            Collection<ObjectFieldType> operationFields = SoapServiceMetadataTypeUtils.getOperationType(bodyType.get()).getFields();
            return !operationFields.isEmpty();
        }
        return false;
    }

    private Optional<Part> getSinglePart(List<String> soapBodyParts, Message inputMessage) {
        if (soapBodyParts.isEmpty()) {
            Map parts = inputMessage.getParts();
            if (parts.size() == 1) {
                return Optional.ofNullable((Part)parts.values().iterator().next());
            }
        } else if (soapBodyParts.size() == 1) {
            String partName = soapBodyParts.get(0);
            return Optional.ofNullable(inputMessage.getPart(partName));
        }
        return Optional.empty();
    }

    private Optional<List<String>> getSoapBodyParts(BindingOperation operation) {
        List elements = operation.getBindingInput().getExtensibilityElements();
        return elements.stream().filter(e -> e instanceof SOAPBody || e instanceof SOAP12Body).map(e -> e instanceof SOAPBody ? ((SOAPBody)e).getParts() : ((SOAP12Body)e).getParts()).map(parts -> parts == null ? Collections.emptyList() : parts).findFirst();
    }
}

