/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.introspection;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import org.mule.metadata.xml.SchemaCollector;
import org.mule.runtime.soap.api.exception.InvalidWsdlException;
import org.mule.service.soap.util.XmlTransformationException;
import org.mule.service.soap.util.XmlTransformationUtils;

final class WsdlSchemasCollector {
    private final Map<String, Schema> schemas = Maps.newHashMap();
    private final Definition definition;

    WsdlSchemasCollector(Definition definition) {
        this.definition = definition;
    }

    public SchemaCollector collect() {
        SchemaCollector collector = SchemaCollector.getInstance();
        this.collectSchemas(this.definition);
        this.schemas.forEach((uri, schema) -> {
            try {
                collector.addSchema((String)uri, XmlTransformationUtils.nodeToString(schema.getElement()));
            }
            catch (XmlTransformationException e) {
                String message = uri.endsWith(".wsdl") ? "Schema embedded in wsdl [%s]" : "Schema [%s]";
                throw new InvalidWsdlException(String.format(message + " could not be parsed", uri), (Throwable)e);
            }
        });
        return collector;
    }

    private void collectSchemas(Definition definition) {
        this.collectFromTypes(definition.getTypes());
        definition.getImports().values().forEach(wsdlImport -> {
            if (wsdlImport instanceof Import) {
                this.collectSchemas(((Import)wsdlImport).getDefinition());
            }
        });
    }

    private void collectFromTypes(Types types) {
        if (types != null) {
            types.getExtensibilityElements().forEach(element -> {
                if (element instanceof Schema) {
                    Schema schema = (Schema)element;
                    this.addSchema(schema);
                }
            });
        }
    }

    private void addSchema(Schema schema) {
        String key = schema.getDocumentBaseURI();
        if (!this.schemas.containsKey(key)) {
            this.schemas.put(key, schema);
            this.addImportedSchemas(schema);
            this.addIncludedSchemas(schema);
        }
    }

    private void addImportedSchemas(Schema schema) {
        Collection imports = schema.getImports().values();
        imports.forEach(vector -> ((Vector)vector).forEach(element -> {
            if (element instanceof SchemaImport) {
                Schema importedSchema = ((SchemaImport)element).getReferencedSchema();
                this.addSchema(importedSchema);
            }
        }));
    }

    private void addIncludedSchemas(Schema schema) {
        schema.getIncludes().forEach(include -> {
            if (include instanceof SchemaReference) {
                this.addSchema(((SchemaReference)include).getReferencedSchema());
            }
        });
    }
}

