/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.List;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.service.soap.introspection.WsdlDefinition;
import org.mule.service.soap.metadata.NodeMetadataResolver;
import org.mule.service.soap.metadata.TypeIntrospecterDelegate;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;

final class AttachmentsMetadataResolver
extends NodeMetadataResolver {
    AttachmentsMetadataResolver(WsdlDefinition definition, TypeLoader loader) {
        super(definition, loader);
    }

    @Override
    public MetadataType getMetadata(String operation, TypeIntrospecterDelegate delegate) throws MetadataResolvingException {
        Part bodyPart = this.definition.getBodyPart(operation, delegate).orElseThrow(() -> new MetadataResolvingException(String.format("operation [%s] does not have a body part", operation), FailureCode.INVALID_CONFIGURATION));
        MetadataType bodyType = this.buildPartMetadataType(bodyPart);
        List<ObjectFieldType> attachments = SoapServiceMetadataTypeUtils.getAttachmentFields(bodyType);
        if (attachments.isEmpty()) {
            return this.nullType;
        }
        ObjectTypeBuilder type = this.typeBuilder.objectType();
        attachments.forEach(attachment -> type.addField().key(MetadataTypeUtils.getLocalPart(attachment)).value(attachment.getValue()));
        return type.build();
    }
}

