/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.Set;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.soap.api.client.metadata.SoapMetadataResolver;
import org.mule.runtime.soap.api.client.metadata.SoapOperationMetadata;
import org.mule.service.soap.introspection.WsdlDefinition;
import org.mule.service.soap.metadata.AttachmentsMetadataResolver;
import org.mule.service.soap.metadata.BodyMetadataResolver;
import org.mule.service.soap.metadata.HeadersMetadataResolver;
import org.mule.service.soap.metadata.ImmutableSoapOperationMetadata;
import org.mule.service.soap.metadata.InputTypeIntrospecterDelegate;
import org.mule.service.soap.metadata.OutputTypeIntrospecterDelegate;
import org.mule.service.soap.metadata.ServiceOperationsResolver;
import org.mule.service.soap.metadata.TypeIntrospecterDelegate;

public class DefaultSoapMetadataResolver
implements SoapMetadataResolver {
    private static final TypeIntrospecterDelegate inputDelegate = new InputTypeIntrospecterDelegate();
    private static final TypeIntrospecterDelegate outputDelegate = new OutputTypeIntrospecterDelegate();
    private final HeadersMetadataResolver headersResolver;
    private final BodyMetadataResolver bodyResolver;
    private final AttachmentsMetadataResolver attachmentsResolver;
    private final ServiceOperationsResolver keysResolver;

    public DefaultSoapMetadataResolver(WsdlDefinition definition, TypeLoader loader) {
        this.bodyResolver = new BodyMetadataResolver(definition, loader);
        this.headersResolver = new HeadersMetadataResolver(definition, loader);
        this.attachmentsResolver = new AttachmentsMetadataResolver(definition, loader);
        this.keysResolver = new ServiceOperationsResolver(definition);
    }

    @Override
    public SoapOperationMetadata getInputMetadata(String operation) throws MetadataResolvingException {
        return new ImmutableSoapOperationMetadata(this.bodyResolver.getMetadata(operation, inputDelegate), this.headersResolver.getMetadata(operation, inputDelegate), this.attachmentsResolver.getMetadata(operation, inputDelegate));
    }

    @Override
    public SoapOperationMetadata getOutputMetadata(String operation) throws MetadataResolvingException {
        return new ImmutableSoapOperationMetadata(this.bodyResolver.getMetadata(operation, outputDelegate), this.headersResolver.getMetadata(operation, outputDelegate), this.attachmentsResolver.getMetadata(operation, outputDelegate));
    }

    @Override
    public Set<String> getAvailableOperations() {
        return this.keysResolver.getAvailableOperations();
    }
}

