/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.json.example.HandlerManager;
import org.mule.metadata.json.example.ParsingContext;

public class JsonExampleTypeLoader
implements TypeLoader {
    private Optional<File> exampleFile;
    private Optional<String> example;

    public JsonExampleTypeLoader(File exampleFile) {
        this.exampleFile = Optional.of(exampleFile);
        this.example = Optional.empty();
    }

    public JsonExampleTypeLoader(String example) {
        this.exampleFile = Optional.empty();
        this.example = Optional.of(example);
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        try (Reader bufferedReader = this.buildReader();){
            JsonElement root = new JsonParser().parse(bufferedReader);
            String content = root.toString();
            ExampleAnnotation example = new ExampleAnnotation(StringEscapeUtils.escapeJson((String)content));
            TypeBuilder<?> typeBuilder = new HandlerManager().handle(root, new ParsingContext().withAnnotation(example));
            MetadataTypeUtils.addTypeAlias(typeBuilder, typeAlias);
            Optional<MetadataType> optional = Optional.of(typeBuilder.build());
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Reader buildReader() throws FileNotFoundException {
        return this.exampleFile.isPresent() ? new FileReader(this.exampleFile.get()) : new StringReader(this.example.orElseThrow(() -> new RuntimeException("No example provided.")));
    }
}

