/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.handler;

import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.json.handler.HandlerManager;
import org.mule.metadata.json.handler.ParsingContext;
import org.mule.metadata.json.handler.SchemaHandler;

public class StringHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof StringSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        StringSchema stringSchema = (StringSchema)schema;
        StringTypeBuilder stringType = root.stringType();
        Integer min = null;
        Integer max = null;
        if (stringSchema.getMinLength() != null && stringSchema.getMinLength() > 0) {
            min = stringSchema.getMinLength();
        }
        if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() > 0) {
            max = stringSchema.getMaxLength();
        }
        if (MetadataTypeUtils.isNotNull(min) || MetadataTypeUtils.isNotNull(max)) {
            stringType.boundary(min, max);
        }
        if (stringSchema.getPattern() != null) {
            stringType.pattern(stringSchema.getPattern().toString());
        }
        return stringType;
    }
}

