/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.service;

import java.util.Objects;
import org.mule.runtime.api.service.Service;

public class ServiceDefinition {
    private final Class<? extends Service> serviceClass;
    private final Service service;

    public ServiceDefinition(Class<? extends Service> serviceInterface, Service service) {
        Objects.requireNonNull(serviceInterface, "ServiceClass cannot be null");
        Objects.requireNonNull(service, "Service cannot be null");
        if (!serviceInterface.isInterface()) {
            throw new IllegalArgumentException("ServiceClass must be an interface");
        }
        if (!serviceInterface.isAssignableFrom(service.getClass())) {
            throw new IllegalArgumentException("Service must be instance of " + serviceInterface + " but is " + service.getClass());
        }
        this.serviceClass = serviceInterface;
        this.service = service;
    }

    public Class<? extends Service> getServiceClass() {
        return this.serviceClass;
    }

    public Service getService() {
        return this.service;
    }
}

