/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.spring;

import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.spring.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.spring.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.internal.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.spring.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.core.api.config.RuntimeConfigurationException;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

class ObjectBeanDefinitionCreator
extends BeanDefinitionCreator {
    private static final String REF_PARAMETER = "ref";
    private static final String CLASS_PARAMETER = "class";

    ObjectBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        if (!componentModel.getIdentifier().equals(ComponentIdentifier.buildFromStringRepresentation("mule:object"))) {
            return false;
        }
        String refParameterValue = componentModel.getParameters().get(REF_PARAMETER);
        String classParameterValue = componentModel.getParameters().get(CLASS_PARAMETER);
        if (refParameterValue != null && classParameterValue != null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Object cannot contain both '%s' and '%s' parameter. Offending resource is '%s'", refParameterValue, classParameterValue, componentModel.getComponentLocation())));
        }
        if (refParameterValue == null && classParameterValue == null) {
            throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Object cannot contain both '%s' and '%s' parameter empty. Offending resource is '%s'", refParameterValue, classParameterValue, componentModel.getComponentLocation())));
        }
        if (refParameterValue != null) {
            componentModel.setBeanReference((BeanReference)new RuntimeBeanReference(refParameterValue));
        }
        if (classParameterValue != null) {
            Class classParameter;
            try {
                classParameter = ClassUtils.getClass((String)classParameterValue);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Could not resolve class '%s' for component '%s'", classParameterValue, componentModel.getComponentLocation())));
            }
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AnnotatedObjectInvocationHandler.addAnnotationsToClass(classParameter));
            CommonBeanDefinitionCreator.processMuleProperties(componentModel, beanDefinitionBuilder, null);
            componentModel.setBeanDefinition((BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
        return true;
    }
}

