/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.exception.MessagingException;

public class EnrichedNotificationInfo {
    private Event event;
    private AnnotatedObject component;
    private Exception exception;
    private FlowCallStack flowCallStack;

    public static EnrichedNotificationInfo createInfo(InternalEvent event, Exception e, AnnotatedObject component) {
        if (event != null) {
            if (component == null && e != null) {
                component = EnrichedNotificationInfo.componentFromException(e);
            }
            EnrichedNotificationInfo notificationInfo = new EnrichedNotificationInfo(event, component, e, event.getFlowCallStack());
            notificationInfo.event = event;
            return notificationInfo;
        }
        if (e != null) {
            if (e instanceof MessagingException) {
                MessagingException messagingException = (MessagingException)e;
                if (messagingException.getEvent() != null) {
                    return EnrichedNotificationInfo.createInfo(messagingException.getEvent(), e, EnrichedNotificationInfo.componentFromException(e));
                }
            } else {
                EnrichedNotificationInfo notificationInfo = new EnrichedNotificationInfo(null, null, e, null);
                notificationInfo.event = event;
                return notificationInfo;
            }
        }
        throw new RuntimeException("Neither event or exception present");
    }

    private static AnnotatedObject componentFromException(Exception e) {
        if (e instanceof MessagingException) {
            return ((MessagingException)e).getFailingComponent();
        }
        return null;
    }

    public EnrichedNotificationInfo(InternalEvent event, AnnotatedObject component, Exception exception, FlowCallStack flowCallStack) {
        this.event = event;
        this.component = component;
        this.exception = exception;
        this.flowCallStack = flowCallStack;
    }

    public Event getEvent() {
        return this.event;
    }

    public AnnotatedObject getComponent() {
        return this.component;
    }

    public Exception getException() {
        return this.exception;
    }

    public FlowCallStack getFlowCallStack() {
        return this.flowCallStack;
    }
}

