/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.map.HashedMap;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.ExceptionMapper;

public class ErrorTypeLocator {
    private ExceptionMapper defaultExceptionMapper;
    private Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers;
    private final ErrorType defaultError;

    private ErrorTypeLocator(ExceptionMapper defaultExceptionMapper, Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers, ErrorType defaultError) {
        this.defaultExceptionMapper = defaultExceptionMapper;
        this.componentExceptionMappers = componentExceptionMappers;
        this.defaultError = defaultError;
    }

    public ErrorType lookupErrorType(Throwable exception) {
        return this.lookupErrorType(exception.getClass());
    }

    public ErrorType lookupErrorType(Class<? extends Throwable> type) {
        return this.defaultExceptionMapper.resolveErrorType(type).orElse(this.defaultError);
    }

    public ErrorType lookupComponentErrorType(ComponentIdentifier componentIdentifier, Class<? extends Throwable> exception) {
        ExceptionMapper exceptionMapper = this.componentExceptionMappers.get(componentIdentifier);
        Optional<ErrorType> errorType = Optional.empty();
        if (exceptionMapper != null) {
            errorType = exceptionMapper.resolveErrorType(exception);
        }
        return errorType.orElseGet(() -> this.lookupErrorType(exception));
    }

    public ErrorType lookupComponentErrorType(ComponentIdentifier componentIdentifier, Throwable exception) {
        return this.lookupComponentErrorType(componentIdentifier, exception.getClass());
    }

    public void addComponentExceptionMapper(ComponentIdentifier componentIdentifier, ExceptionMapper exceptionMapper) {
        this.componentExceptionMappers.put(componentIdentifier, exceptionMapper);
    }

    public static Builder builder(ErrorTypeRepository errorTypeRepository) {
        return new Builder(errorTypeRepository);
    }

    public static class Builder {
        private ErrorType defaultError;
        private ExceptionMapper defaultExceptionMapper;
        private Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers = new HashedMap();

        public Builder(ErrorTypeRepository errorTypeRepository) {
            Preconditions.checkArgument(errorTypeRepository != null, "error type repository cannot be null");
        }

        public Builder defaultExceptionMapper(ExceptionMapper exceptionMapper) {
            this.defaultExceptionMapper = exceptionMapper;
            return this;
        }

        public Builder addComponentExceptionMapper(ComponentIdentifier componentIdentifier, ExceptionMapper exceptionMapper) {
            this.componentExceptionMappers.put(componentIdentifier, exceptionMapper);
            return this;
        }

        public ErrorTypeLocator build() {
            Preconditions.checkState(this.defaultExceptionMapper != null, "default exception mapper cannot not be null");
            Preconditions.checkState(this.componentExceptionMappers != null, "component exception mappers cannot not be null");
            Preconditions.checkState(this.defaultError != null, "default error cannot not be null");
            return new ErrorTypeLocator(this.defaultExceptionMapper, this.componentExceptionMappers, this.defaultError);
        }

        public Builder defaultError(ErrorType defaultError) {
            this.defaultError = defaultError;
            return this;
        }
    }
}

