/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.source.polling;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.source.polling.PeriodicScheduler;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@Alias(value="fixed-frequency")
public class FixedFrequencyScheduler
extends PeriodicScheduler {
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    @Parameter
    @Optional(defaultValue="1000")
    private long frequency = 1000L;
    @Parameter
    @Optional(defaultValue="0")
    private long startDelay = 1000L;

    @Override
    public ScheduledFuture<?> doSchedule(Scheduler executor, Runnable job) {
        return executor.scheduleAtFixedRate(job, this.startDelay, this.frequency, this.timeUnit);
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setFrequency(long frequency) {
        Preconditions.checkArgument(frequency > 0L, "Frequency must be greater then zero");
        this.frequency = frequency;
    }

    public void setStartDelay(long startDelay) {
        Preconditions.checkArgument(startDelay >= 0L, "Start delay must be greater then zero");
        this.startDelay = startDelay;
    }
}

