/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.client;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.client.MuleClient;
import org.mule.runtime.core.api.client.MuleClientFlowConstruct;
import org.mule.runtime.core.api.client.OperationOptions;
import org.mule.runtime.core.api.client.SimpleOptionsBuilder;
import org.mule.runtime.core.api.connector.ConnectorOperationLocator;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.message.ErrorBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class DefaultLocalMuleClient
implements MuleClient {
    public static final String MESSAGE_FILTERED_ERROR_MESSAGE = "message filtered";
    protected final MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private ConnectorOperationLocator connectorOperatorLocator;

    public DefaultLocalMuleClient(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.flowConstruct = new MuleClientFlowConstruct(muleContext);
    }

    protected ConnectorOperationLocator getConnectorMessageProcessLocator() {
        if (this.connectorOperatorLocator == null) {
            this.connectorOperatorLocator = (ConnectorOperationLocator)this.muleContext.getRegistry().get("_muleConnectorMessageProcessorLocator");
            if (this.connectorOperatorLocator == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not find required %s in the registry under key %s", ConnectorOperationLocator.class.getName(), "_muleConnectorMessageProcessorLocator"));
            }
        }
        return this.connectorOperatorLocator;
    }

    @Override
    public void dispatch(String url, Object payload, Map<String, Serializable> messageProperties) throws MuleException {
        this.dispatch(url, this.createMessage(payload, messageProperties));
    }

    @Override
    public Either<Error, Message> send(String url, Object payload, Map<String, Serializable> messageProperties) throws MuleException {
        return this.send(url, this.createMessage(payload, messageProperties));
    }

    @Override
    public Either<Error, Message> send(String url, Message message) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, ((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().outbound()).build(), MessageExchangePattern.REQUEST_RESPONSE);
        if (connectorMessageProcessor != null) {
            return this.createEitherResult(connectorMessageProcessor.process(this.createMuleEvent(message)));
        }
        throw this.createUnsupportedUrlException(url);
    }

    private Either<Error, Message> createEitherResult(InternalEvent muleEvent) {
        if (muleEvent == null) {
            ErrorType anyErrorType = this.muleContext.getErrorTypeRepository().getAnyErrorType();
            return Either.left(ErrorBuilder.builder(new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MESSAGE_FILTERED_ERROR_MESSAGE))).errorType(anyErrorType).build());
        }
        if (!muleEvent.getError().isPresent()) {
            return Either.right(muleEvent.getMessage());
        }
        return Either.left(muleEvent.getError().get());
    }

    @Override
    public Either<Error, Message> send(String url, Message message, OperationOptions operationOptions) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, operationOptions, MessageExchangePattern.REQUEST_RESPONSE);
        if (connectorMessageProcessor != null) {
            return this.createEitherResult(this.returnEvent(connectorMessageProcessor.process(this.createMuleEvent(message))));
        }
        throw this.createUnsupportedUrlException(url);
    }

    private MuleException createUnsupportedUrlException(String url) {
        return new DefaultMuleException("No installed connector supports url " + url);
    }

    @Override
    public Either<Error, Message> send(String url, Object payload, Map<String, Serializable> messageProperties, long timeout) throws MuleException {
        return this.send(url, this.createMessage(payload, messageProperties), timeout);
    }

    @Override
    public Either<Error, Message> send(String url, Message message, long timeout) throws MuleException {
        return this.send(url, message, ((SimpleOptionsBuilder)((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().outbound()).responseTimeout(timeout)).build());
    }

    protected Message createMessage(Object payload, Map<String, Serializable> messageProperties) {
        InternalMessage.Builder builder = InternalMessage.builder().value(payload);
        if (messageProperties != null) {
            builder.outboundProperties(messageProperties);
        }
        return builder.build();
    }

    @Override
    public void dispatch(String url, Message message) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, ((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().outbound()).build(), MessageExchangePattern.ONE_WAY);
        if (connectorMessageProcessor == null) {
            throw this.createUnsupportedUrlException(url);
        }
        connectorMessageProcessor.process(this.createMuleEvent(message));
    }

    @Override
    public void dispatch(String url, Message message, OperationOptions operationOptions) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, operationOptions, MessageExchangePattern.ONE_WAY);
        if (connectorMessageProcessor != null) {
            connectorMessageProcessor.process(this.createMuleEvent(message));
        } else {
            this.dispatch(url, message);
        }
    }

    @Override
    public Either<Error, Optional<Message>> request(String url, long timeout) throws MuleException {
        OperationOptions operationOptions = ((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().responseTimeout(timeout)).build();
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, operationOptions, MessageExchangePattern.ONE_WAY);
        if (connectorMessageProcessor != null) {
            InternalEvent event = connectorMessageProcessor.process(this.createMuleEvent(Message.of(null)));
            if (event == null) {
                return Either.right(Optional.empty());
            }
            if (event.getError().isPresent()) {
                return Either.left(event.getError().get());
            }
            return Either.right(Optional.ofNullable(event.getMessage()));
        }
        return Either.right(Optional.empty());
    }

    protected InternalEvent createMuleEvent(Message message) throws MuleException {
        return this.baseEventBuilder(message).build();
    }

    private InternalEvent.Builder baseEventBuilder(Message message) {
        return InternalEvent.builder(DefaultEventContext.create(this.flowConstruct, DefaultComponentLocation.fromSingleComponent("muleClient"))).message(message).flow(this.flowConstruct);
    }

    protected InternalEvent returnEvent(InternalEvent event) {
        if (event != null) {
            return event;
        }
        return null;
    }
}

