/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessageRedeliveredException;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.TemplateOnErrorHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    private Integer maxRedeliveryAttempts;

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
    }

    public void setMaxRedeliveryAttempts(Integer maxRedeliveryAttempts) {
        this.maxRedeliveryAttempts = maxRedeliveryAttempts;
    }

    public Integer getMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts;
    }

    public boolean hasMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts != null;
    }

    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && this.when == null;
    }

    @Override
    protected Function<InternalEvent, InternalEvent> beforeRouting(MessagingException exception) {
        return event -> {
            event = super.beforeRouting(exception).apply((InternalEvent)event);
            if (!this.isRedeliveryExhausted(exception)) {
                this.rollback(exception);
            }
            return event;
        };
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return new ArrayList<Processor>(super.getOwnedMessageProcessors());
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        return exception instanceof MessageRedeliveredException;
    }

    @Override
    protected Function<InternalEvent, Publisher<InternalEvent>> route(MessagingException exception) {
        if (!this.isRedeliveryExhausted(exception)) {
            return super.route(exception);
        }
        this.logger.info("Message redelivery exhausted. No redelivery exhausted actions configured. Message consumed.");
        return event -> Mono.just((Object)event);
    }

    @Override
    protected InternalEvent processReplyTo(InternalEvent event, Exception e) {
        if (this.isRedeliveryExhausted(e)) {
            return super.processReplyTo(event, e);
        }
        return event;
    }
}

