/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessorExpressionPair
extends AbstractAnnotatedObject
implements MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorExpressionPair.class);
    private final String expression;
    private final Processor messageProcessor;

    public MessageProcessorExpressionPair(String expression, Processor messageProcessor) {
        Objects.requireNonNull(expression, "expression can't be null");
        Objects.requireNonNull(messageProcessor, "messageProcessor can't be null");
        this.expression = expression;
        this.messageProcessor = messageProcessor;
    }

    public String getExpression() {
        return this.expression;
    }

    public Processor getMessageProcessor() {
        return this.messageProcessor;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        if (this.messageProcessor instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.messageProcessor)).setMuleContext(context);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.messageProcessor);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.messageProcessor);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.messageProcessor);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.messageProcessor, LOGGER);
    }
}

