/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.store.DeserializationPostInitialisable;
import org.mule.runtime.core.api.store.ExpirableObjectStore;
import org.mule.runtime.core.api.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentObjectStorePartition<T extends Serializable>
extends TemplateObjectStore<T>
implements ExpirableObjectStore<T> {
    private static final String OBJECT_FILE_EXTENSION = ".obj";
    private static final String PARTITION_DESCRIPTOR_FILE = "partition-descriptor";
    public static final String CORRUPTED_FOLDER = "corrupted-files";
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentObjectStorePartition.class);
    private final MuleContext muleContext;
    private final ObjectSerializer serializer;
    private boolean loaded = false;
    private File partitionDirectory;
    private String partitionName;
    private final BidiMap realKeyToUUIDIndex = new TreeBidiMap();

    public PersistentObjectStorePartition(MuleContext muleContext, String partitionName, File partitionDirectory) {
        this.muleContext = muleContext;
        this.serializer = muleContext.getObjectSerializer();
        this.partitionName = partitionName;
        this.partitionDirectory = partitionDirectory;
    }

    public PersistentObjectStorePartition(MuleContext muleContext, File partitionDirectory) throws ObjectStoreNotAvailableException {
        this.muleContext = muleContext;
        this.serializer = muleContext.getObjectSerializer();
        this.partitionDirectory = partitionDirectory;
        this.partitionName = this.readPartitionFileName(partitionDirectory);
    }

    private String readPartitionFileName(File partitionDirectory) throws ObjectStoreNotAvailableException {
        File partitionDescriptorFile = new File(partitionDirectory, PARTITION_DESCRIPTOR_FILE);
        try {
            return FileUtils.readFileToString((File)partitionDescriptorFile);
        }
        catch (IOException e) {
            throw new ObjectStoreNotAvailableException(e);
        }
    }

    @Override
    public synchronized void open() throws ObjectStoreException {
        this.createDirectory(this.partitionDirectory);
        this.createOrRetrievePartitionDescriptorFile();
    }

    @Override
    public void close() throws ObjectStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> allKeys() throws ObjectStoreException {
        this.assureLoaded();
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            return Collections.unmodifiableList(new ArrayList(this.realKeyToUUIDIndex.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doContains(String key) throws ObjectStoreException {
        this.assureLoaded();
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            return this.realKeyToUUIDIndex.containsKey((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStore(String key, T value) throws ObjectStoreException {
        this.assureLoaded();
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            if (this.realKeyToUUIDIndex.containsKey((Object)key)) {
                throw new ObjectAlreadyExistsException();
            }
            File newFile = this.createFileToStoreObject();
            this.realKeyToUUIDIndex.put((Object)key, (Object)newFile.getName());
            this.serialize(newFile, new StoreValue<T>((Serializable)((Object)key), value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws ObjectStoreException {
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            try {
                org.mule.runtime.core.api.util.FileUtils.cleanDirectory(this.partitionDirectory);
            }
            catch (IOException e) {
                throw new ObjectStoreException(I18nMessageFactory.createStaticMessage("Could not clear ObjectStore"), (Throwable)e);
            }
            this.realKeyToUUIDIndex.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T doRetrieve(String key) throws ObjectStoreException {
        this.assureLoaded();
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            if (!this.realKeyToUUIDIndex.containsKey((Object)key)) {
                throw new ObjectDoesNotExistException(I18nMessageFactory.createStaticMessage("Key does not exist: " + key));
            }
            String filename = (String)this.realKeyToUUIDIndex.get((Object)key);
            File file = this.getValueFile(filename);
            return (T)((Serializable)this.deserialize(file).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T doRemove(String key) throws ObjectStoreException {
        this.assureLoaded();
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            Object value = this.retrieve(key);
            this.deleteStoreFile(this.getValueFile((String)this.realKeyToUUIDIndex.get((Object)key)));
            return value;
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(long entryTTL, int maxEntries) throws ObjectStoreException {
        this.assureLoaded();
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            Long lastModified;
            File[] files = this.listValuesFiles();
            Arrays.sort(files, (f1, f2) -> {
                int result = Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                if (result == 0) {
                    result = f1.getName().compareTo(f2.getName());
                }
                return result;
            });
            int startIndex = this.trimToMaxSize(files, maxEntries);
            if (entryTTL == 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            for (int i = startIndex; i < files.length && now - (lastModified = Long.valueOf(files[i].lastModified())) >= entryTTL; ++i) {
                this.deleteStoreFile(files[i]);
            }
        }
    }

    private void assureLoaded() throws ObjectStoreException {
        if (!this.loaded) {
            this.loadStoredKeysAndFileNames();
        }
    }

    private void moveToCorruptedFilesFolder(File file) throws IOException {
        String workingDirectory = new File(this.muleContext.getConfiguration().getWorkingDirectory()).toPath().normalize().toString();
        String diffFolder = file.getAbsolutePath().split(workingDirectory)[1];
        File corruptedFile = new File(this.muleContext.getConfiguration().getWorkingDirectory() + File.separator + CORRUPTED_FOLDER + diffFolder);
        FileUtils.moveFileToDirectory((File)file, (File)corruptedFile.getParentFile(), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStoredKeysAndFileNames() throws ObjectStoreException {
        BidiMap bidiMap = this.realKeyToUUIDIndex;
        synchronized (bidiMap) {
            if (this.loaded) {
                return;
            }
            try {
                File[] files;
                for (File file : files = this.listValuesFiles()) {
                    try {
                        StoreValue<T> storeValue = this.deserialize(file);
                        this.realKeyToUUIDIndex.put((Object)storeValue.getKey(), (Object)file.getName());
                    }
                    catch (ObjectStoreException e) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn(String.format("Could not deserialize the ObjectStore file: %s. The file will be skipped and moved to the Garbage folder", file.getName()));
                        }
                        this.moveToCorruptedFilesFolder(file);
                    }
                }
                this.loaded = true;
            }
            catch (Exception e) {
                throw new ObjectStoreException(I18nMessageFactory.createStaticMessage(String.format("Could not restore object store data from %1s", this.partitionDirectory.getAbsolutePath())));
            }
        }
    }

    private File[] listValuesFiles() {
        File[] files = this.partitionDirectory.listFiles(file -> !file.isDirectory() && file.getName().endsWith(OBJECT_FILE_EXTENSION));
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    protected void createDirectory(File directory) throws ObjectStoreException {
        try {
            if (!directory.exists() && !directory.mkdirs()) {
                throw new MuleRuntimeException(CoreMessages.failedToCreate("object store directory " + directory.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    private File getValueFile(String filename) {
        return new File(this.partitionDirectory, filename);
    }

    protected File createFileToStoreObject() throws ObjectStoreException {
        String filename = UUID.getUUID() + OBJECT_FILE_EXTENSION;
        try {
            return org.mule.runtime.core.api.util.FileUtils.newFile(this.partitionDirectory, filename);
        }
        catch (MuleRuntimeException mre) {
            throw new ObjectStoreException(mre);
        }
    }

    protected File createOrRetrievePartitionDescriptorFile() throws ObjectStoreException {
        try {
            File partitionDescriptorFile = new File(this.partitionDirectory, PARTITION_DESCRIPTOR_FILE);
            if (partitionDescriptorFile.exists()) {
                this.partitionName = this.readPartitionFileName(this.partitionDirectory);
                return partitionDescriptorFile;
            }
            try (FileWriter fileWriter = new FileWriter(partitionDescriptorFile.getAbsolutePath(), false);){
                fileWriter.write(this.partitionName);
                fileWriter.flush();
            }
            return partitionDescriptorFile;
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    protected void serialize(File outputFile, StoreValue<T> storeValue) throws ObjectStoreException {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));){
            this.serializer.getInternalProtocol().serialize(storeValue, objectOutputStream);
            objectOutputStream.flush();
        }
        catch (Exception se) {
            throw new ObjectStoreException(se);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StoreValue<T> deserialize(File file) throws ObjectStoreException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
            StoreValue storedValue = (StoreValue)this.serializer.getInternalProtocol().deserialize(objectInputStream);
            if (storedValue.getValue() instanceof DeserializationPostInitialisable) {
                DeserializationPostInitialisable.Implementation.init(storedValue.getValue(), this.muleContext);
            }
            StoreValue storeValue = storedValue;
            return storeValue;
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    protected void deleteStoreFile(File file) throws ObjectStoreException {
        if (file.exists()) {
            if (!file.delete()) {
                throw new ObjectStoreException(I18nMessageFactory.createStaticMessage("Deleting " + file.getAbsolutePath() + " failed"));
            }
        } else {
            throw new ObjectDoesNotExistException();
        }
        this.realKeyToUUIDIndex.removeValue((Object)file.getName());
    }

    private int trimToMaxSize(File[] files, int maxEntries) throws ObjectStoreException {
        if (maxEntries == 0) {
            return 0;
        }
        int expired = 0;
        int excess = files.length - maxEntries;
        if (excess > 0) {
            for (int i = 0; i < excess; ++i) {
                this.deleteStoreFile(files[i]);
                ++expired;
            }
        }
        return expired;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public static class StoreValue<T>
    implements Serializable {
        private Serializable key;
        private T value;

        public StoreValue(Serializable key, T value) {
            this.key = key;
            this.value = value;
        }

        public Serializable getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }
    }
}

