/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class SecurityFilterMessageProcessor
extends AbstractAnnotatedObject
implements Processor,
Initialisable,
MuleContextAware {
    private MuleContext muleContext;
    private SecurityFilter filter;

    public SecurityFilterMessageProcessor(SecurityFilter filter) {
        this.filter = filter;
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.muleContext.getInjector().inject(this.filter);
            LifecycleUtils.initialiseIfNeeded(this.filter, this.muleContext);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public SecurityFilter getFilter() {
        return this.filter;
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Flux.from(publisher).doOnNext(event -> {
            try {
                this.filter.doFilter((InternalEvent)event);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    public void setFilter(SecurityFilter filter) {
        this.filter = filter;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

