/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.objectfactory;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.dsl.api.component.AbstractAnnotatedObjectFactory;

public class MessageProcessorChainObjectFactory
extends AbstractAnnotatedObjectFactory<MessageProcessorChain> {
    @Inject
    protected MuleContext muleContext;
    protected List processors;
    protected String name;

    public void setMessageProcessors(List processors) {
        this.processors = processors;
    }

    @Override
    public MessageProcessorChain doGetObject() throws Exception {
        MessageProcessorChainBuilder builder = this.getBuilderInstance();
        for (Object processor : this.processors) {
            if (processor instanceof Processor) {
                builder.chain((Processor)processor);
                continue;
            }
            throw new IllegalArgumentException(String.format("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured. Found a %s", processor.getClass().getName()));
        }
        MessageProcessorChain messageProcessorChain = builder.build();
        messageProcessorChain.setMuleContext(this.muleContext);
        return messageProcessorChain;
    }

    protected MessageProcessorChainBuilder getBuilderInstance() {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("processor chain '" + this.name + "'");
        return builder;
    }

    public void setName(String name) {
        this.name = name;
    }
}

