/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.routing.RouterResultsHandler;

public class DefaultRouterResultsHandler
implements RouterResultsHandler {
    private boolean returnCollectionWithSingleResult = false;

    public DefaultRouterResultsHandler() {
    }

    public DefaultRouterResultsHandler(boolean returnCollectionWithSingleResult) {
        this.returnCollectionWithSingleResult = returnCollectionWithSingleResult;
    }

    @Override
    public InternalEvent aggregateResults(List<InternalEvent> results, InternalEvent previous) {
        if (results == null) {
            return null;
        }
        if (results.size() == 1) {
            InternalEvent event = results.get(0);
            if (event == null) {
                return event;
            }
            if (event != null && event.getMessage() != null) {
                if (this.returnCollectionWithSingleResult) {
                    return this.createMessageCollectionWithSingleMessage(event);
                }
                return event;
            }
            return previous;
        }
        List<InternalEvent> nonNullResults = results.stream().filter(object -> object != null && object.getMessage() != null).collect(Collectors.toList());
        if (nonNullResults.size() == 0) {
            return InternalEvent.builder(previous).message(Message.of(null)).build();
        }
        if (nonNullResults.size() == 1) {
            return (InternalEvent)nonNullResults.get(0);
        }
        return this.createMessageCollection(nonNullResults, previous);
    }

    private InternalEvent createMessageCollectionWithSingleMessage(InternalEvent event) {
        Message coll = Message.builder().collectionValue(Collections.singletonList(event.getMessage()), Message.class).build();
        event = InternalEvent.builder(event).message(coll).build();
        InternalEvent.setCurrentEvent(event);
        return event;
    }

    private InternalEvent createMessageCollection(List<InternalEvent> nonNullResults, InternalEvent previous) {
        InternalEvent.Builder resultBuilder = InternalEvent.builder(previous);
        ArrayList<Message> list = new ArrayList<Message>();
        for (InternalEvent event : nonNullResults) {
            for (String flowVarName : event.getVariables().keySet()) {
                resultBuilder.addVariable(flowVarName, event.getVariables().get(flowVarName).getValue(), event.getVariables().get(flowVarName).getDataType());
            }
            list.add(event.getMessage());
        }
        Message coll = Message.builder().collectionValue(list, Message.class).build();
        InternalEvent resultEvent = resultBuilder.message(coll).build();
        InternalEvent.setCurrentEvent(resultEvent);
        return resultEvent;
    }
}

