/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.internal.property.InfrastructureParameterModelProperty;

public class ExtensionModelUtils {
    private ExtensionModelUtils() {
    }

    public static Optional<String> getDefaultValue(ParameterModel model) {
        Object defaultValue = model.getDefaultValue();
        return defaultValue == null ? Optional.empty() : Optional.of(String.valueOf(defaultValue));
    }

    public static Optional<String> getDefaultValue(final String name, MetadataType model) {
        final Reference value = new Reference();
        model.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                MetadataTypeUtils.getDefaultValue(metadataType).ifPresent(value::set);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                objectType.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals(name)).findFirst().ifPresent(fieldType -> MetadataTypeUtils.getDefaultValue(fieldType).ifPresent(value::set));
            }

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().stream().map(type -> ExtensionModelUtils.getDefaultValue(name, type)).filter(Optional::isPresent).findFirst().ifPresent(defaultValue -> {
                    String cfr_ignored_0 = (String)value.set(defaultValue.get());
                });
            }
        });
        return Optional.ofNullable(value.get());
    }

    public static List<ParameterModel> getDynamicParameters(ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(parameter -> ExtensionModelUtils.acceptsExpressions(parameter.getExpressionSupport())).collect(Collectors.toList());
    }

    public static boolean acceptsExpressions(ExpressionSupport support) {
        return support == ExpressionSupport.SUPPORTED || support == ExpressionSupport.REQUIRED;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new IdempotentExtensionWalker(){

            @Override
            public void onOperation(OperationModel model) {
                this.collect(model);
            }

            @Override
            public void onSource(SourceModel model) {
                this.collect(model);
            }

            private void collect(ConnectableComponentModel model) {
                if (model.requiresConnection()) {
                    connectedModels.add(model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static List<ComponentModel> getConnectedComponents(ExtensionModel extensionModel, final ConfigurationModel configurationModel) {
        final LinkedList<ComponentModel> connectedModels = new LinkedList<ComponentModel>();
        new ExtensionWalker(){

            @Override
            public void onOperation(HasOperationModels owner, OperationModel model) {
                if (owner == configurationModel) {
                    this.collect(owner, model);
                }
            }

            @Override
            public void onSource(HasSourceModels owner, SourceModel model) {
                this.collect(owner, model);
            }

            private void collect(Object owner, ConnectableComponentModel model) {
                if (owner == configurationModel && model.requiresConnection()) {
                    connectedModels.add(model);
                }
            }
        }.walk(extensionModel);
        return connectedModels;
    }

    public static boolean requiresConfig(ExtensionModel extensionModel, final NamedObject component) {
        if (!(component instanceof ConnectableComponentModel)) {
            return false;
        }
        ConnectableComponentModel model = (ConnectableComponentModel)component;
        if (model.requiresConnection()) {
            return true;
        }
        final Reference<Boolean> result = new Reference<Boolean>(false);
        new ExtensionWalker(){

            @Override
            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.resolve(model, owner);
            }

            @Override
            public void onSource(HasSourceModels owner, SourceModel model) {
                this.resolve(model, owner);
            }

            private void resolve(ComponentModel model, Object owner) {
                if (!(owner instanceof ExtensionModel) && model == component) {
                    result.set(true);
                }
            }
        }.walk(extensionModel);
        return result.get();
    }

    public static Set<ConfigurationModel> getConfigurationForComponent(final ExtensionModel extensionModel, final ComponentModel component) {
        final HashSet<ConfigurationModel> result = new HashSet<ConfigurationModel>();
        new ExtensionWalker(){

            @Override
            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.resolve(model, owner);
            }

            @Override
            public void onSource(HasSourceModels owner, SourceModel model) {
                this.resolve(model, owner);
            }

            private void resolve(ComponentModel model, Object owner) {
                if (model == component && owner != extensionModel) {
                    result.add((ConfigurationModel)owner);
                }
            }
        }.walk(extensionModel);
        if (component instanceof ConnectableComponentModel && ((ConnectableComponentModel)component).requiresConnection()) {
            extensionModel.getConfigurationModel("config").ifPresent(result::add);
        }
        return result;
    }

    public static boolean isContent(ParameterModel parameterModel) {
        return ExtensionModelUtils.isContent(parameterModel.getRole());
    }

    public static boolean isText(ParameterModel parameter) {
        return parameter.getLayoutModel().map(LayoutModel::isText).orElse(false);
    }

    public static boolean isContent(ParameterRole purpose) {
        Preconditions.checkArgument(purpose != null, "cannot evaluate null purpose");
        return purpose != ParameterRole.BEHAVIOUR;
    }

    public static ParameterRole roleOf(Optional<Content> content) {
        return content.map(c -> c.primary() ? ParameterRole.PRIMARY_CONTENT : ParameterRole.CONTENT).orElse(ParameterRole.BEHAVIOUR);
    }

    public static Map<ObjectType, Set<ObjectType>> toSubTypesMap(Collection<SubTypesModel> subTypes) {
        return subTypes.stream().collect(Collectors.toMap(SubTypesModel::getBaseType, SubTypesModel::getSubTypes));
    }

    public static boolean isInfrastructure(ParameterModel parameter) {
        return parameter.getModelProperty(InfrastructureParameterModelProperty.class).isPresent();
    }

    public static <T extends ParameterizedModel> T getFirstImplicit(List<T> models) {
        return (T)((ParameterizedModel)models.stream().filter(ExtensionModelUtils::canBeUsedImplicitly).findFirst().orElse(null));
    }

    public static boolean canBeUsedImplicitly(ParameterizedModel parameterizedModel) {
        return parameterizedModel.getAllParameterModels().stream().noneMatch(ParameterModel::isRequired);
    }

    public static String getDefaultValue(org.mule.runtime.extension.api.annotation.param.Optional optional) {
        if (optional == null) {
            return null;
        }
        String defaultValue = optional.defaultValue();
        return "THIS IS A SPECIAL NULL VALUE - DO NOT USE".equals(defaultValue) ? null : defaultValue;
    }

    public static Object getDefaultValue(AccessibleObject object) {
        return ExtensionModelUtils.getDefaultValue(object.getAnnotation(org.mule.runtime.extension.api.annotation.param.Optional.class));
    }

    public static boolean isRequired(ParameterGroupModel group) {
        return group.getParameterModels().stream().anyMatch(ParameterModel::isRequired);
    }
}

