/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.Map;
import org.mule.runtime.config.builders.PropertiesMuleConfigurationFactory;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.DefaultMuleContextBuilder;
import org.mule.runtime.core.api.util.StringUtils;

public class ApplicationMuleContextBuilder
extends DefaultMuleContextBuilder {
    private final Map<String, String> appProperties;
    private final String appName;
    private final String defaultEncoding;

    public ApplicationMuleContextBuilder(String appName, Map<String, String> appProperties, String defaultEncoding) {
        this.appProperties = appProperties;
        this.appName = appName;
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    protected DefaultMuleContext createDefaultMuleContext() {
        DefaultMuleContext muleContext = super.createDefaultMuleContext();
        muleContext.setArtifactType(ArtifactType.APP);
        return muleContext;
    }

    @Override
    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration(true);
        PropertiesMuleConfigurationFactory.initializeFromProperties(configuration, this.appProperties);
        configuration.setId(this.appName);
        String encoding = this.defaultEncoding;
        if (!StringUtils.isBlank(encoding)) {
            configuration.setDefaultEncoding(encoding);
        }
        return configuration;
    }
}

