/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class ParameterDescriptionDocumenter
extends AbstractDescriptionDocumenter<ParameterizedDeclaration<?>> {
    ParameterDescriptionDocumenter(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    void document(ParameterizedDeclaration<?> parameterized, MethodDocumentation documentation) {
        parameterized.getAllParameters().forEach(p -> {
            String description = documentation.getParameters().get(p.getName());
            if (description != null) {
                p.setDescription(description);
            }
        });
    }

    @Override
    void document(ParameterizedDeclaration<?> parameterized, TypeElement element) {
        Map<String, VariableElement> variableElements = processor.getFieldsAnnotatedWith(element, Parameter.class);
        TypeElement traversingElement = element;
        while (traversingElement != null && !Object.class.getName().equals(traversingElement.getQualifiedName().toString())) {
            Class declaringClass = processor.classFor(traversingElement, this.processingEnv).get();
            parameterized.getAllParameters().forEach(param -> IntrospectionUtils.getField(declaringClass, param).filter(field -> variableElements.containsKey(field.getName())).ifPresent(field -> {
                String summary = processor.getJavaDocSummary(this.processingEnv, (Element)variableElements.get(field.getName()));
                param.setDescription(summary);
            }));
            traversingElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(traversingElement.getSuperclass());
        }
        for (VariableElement variableElement : processor.getFieldsAnnotatedWith(element, ParameterGroup.class).values()) {
            TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            this.document(parameterized, typeElement);
        }
    }
}

