/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.util.LazyLookup;
import org.mule.runtime.core.internal.util.store.LazyObjectStoreToMapAdapter;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.runtime.module.extension.api.runtime.connectivity.oauth.ImmutableAuthCodeRequest;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.AuthCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthCallbackConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.AuthorizationCodeRequest;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtensionsOAuthManager
implements Initialisable,
Startable,
Stoppable,
ExtensionsOAuthManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionsOAuthManager.class);
    private static final String DANCE_CALLBACK_EVENT_KEY = "event";
    @Inject
    private MuleContext muleContext;
    private LazyValue<HttpService> httpService;
    private LazyValue<OAuthService> oauthService;
    private final Map<String, AuthorizationCodeOAuthDancer> dancers = new ConcurrentHashMap<String, AuthorizationCodeOAuthDancer>();
    private boolean started = false;

    @Override
    public void initialise() throws InitialisationException {
        this.httpService = new LazyLookup<HttpService>(HttpService.class, this.muleContext);
        this.oauthService = new LazyLookup<OAuthService>(OAuthService.class, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        for (AuthorizationCodeOAuthDancer dancer : this.dancers.values()) {
            this.start(dancer);
        }
        this.started = true;
    }

    @Override
    public void register(OAuthConfig config) throws MuleException {
        this.dancers.computeIfAbsent(config.getOwnerConfigName(), k -> this.createDancer(config));
    }

    @Override
    public void invalidate(String ownerConfigName, String resourceOwnerId) {
        AuthorizationCodeOAuthDancer dancer = this.dancers.get(ownerConfigName);
        if (dancer == null) {
            return;
        }
        dancer.invalidateContext(resourceOwnerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(String ownerConfigName, AuthorizationCodeOAuthDancer dancer) {
        try {
            LifecycleUtils.stopIfNeeded(dancer);
        }
        catch (Exception e) {
            LOGGER.warn("Found exception trying to Stop OAuth dancer for config " + ownerConfigName, (Throwable)e);
        }
        finally {
            LifecycleUtils.disposeIfNeeded(dancer, LOGGER);
        }
    }

    @Override
    public void stop() throws MuleException {
        this.dancers.forEach((key, dancer) -> {
            try {
                this.disable((String)key, (AuthorizationCodeOAuthDancer)dancer);
            }
            catch (Exception e) {
                LOGGER.warn("Found exception while trying to stop OAuth callback for config " + key, (Throwable)e);
            }
        });
        this.dancers.clear();
    }

    @Override
    public void refreshToken(String ownerConfigName, String resourceOwnerId, OAuthConnectionProviderWrapper connectionProvider) {
        AuthorizationCodeOAuthDancer dancer = this.dancers.get(ownerConfigName);
        try {
            dancer.refreshToken(resourceOwnerId).get();
            connectionProvider.updateAuthState();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not refresh token for resourceOwnerId '%s' using config '%s'", resourceOwnerId, ownerConfigName)), (Throwable)e);
        }
    }

    @Override
    public Optional<ResourceOwnerOAuthContext> getOAuthContext(OAuthConfig config) {
        AuthorizationCodeOAuthDancer dancer = this.dancers.get(config.getOwnerConfigName());
        if (dancer == null) {
            return Optional.empty();
        }
        ResourceOwnerOAuthContext contextForResourceOwner = dancer.getContextForResourceOwner(config.getAuthCodeConfig().getResourceOwnerId());
        if (contextForResourceOwner == null || contextForResourceOwner.getAccessToken() == null) {
            return Optional.empty();
        }
        return Optional.of(contextForResourceOwner);
    }

    private AuthorizationCodeOAuthDancer createDancer(OAuthConfig config) throws MuleException {
        HttpServer httpServer;
        OAuthAuthorizationCodeDancerBuilder dancerBuilder = this.oauthService.get().authorizationCodeGrantTypeDancerBuilder(lockId -> this.muleContext.getLockFactory().createLock(lockId), new LazyObjectStoreToMapAdapter(this.getObjectStoreSupplier(config)), this.muleContext.getExpressionManager());
        AuthCodeConfig authCodeConfig = config.getAuthCodeConfig();
        AuthorizationCodeGrantType grantType = config.getGrantType();
        OAuthCallbackConfig callbackConfig = config.getCallbackConfig();
        dancerBuilder.encoding(SystemUtils.getDefaultEncoding(this.muleContext)).clientCredentials(authCodeConfig.getConsumerKey(), authCodeConfig.getConsumerSecret()).tokenUrl(authCodeConfig.getAccessTokenUrl()).responseExpiresInExpr(grantType.getExpirationRegex()).responseRefreshTokenExpr(grantType.getRefreshTokenExpr()).responseAccessTokenExpr(grantType.getAccessTokenExpr()).resourceOwnerIdTransformer(ownerId -> ownerId + "-" + config.getOwnerConfigName());
        String scopes = authCodeConfig.getScope().orElseGet(() -> grantType.getDefaultScope().orElse(null));
        if (scopes != null) {
            dancerBuilder.scopes(scopes);
        }
        try {
            httpServer = this.httpService.get().getServerFactory().lookup(callbackConfig.getListenerConfig());
        }
        catch (ServerNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Connector '%s' defines '%s' as the http:listener-config to use for provisioning callbacks, but no such definition exists in the application configuration", config.getOwnerConfigName(), callbackConfig.getListenerConfig())), (Throwable)e);
        }
        dancerBuilder.localCallback(httpServer, callbackConfig.getCallbackPath()).externalCallbackUrl(this.getExternalCallback(httpServer, callbackConfig)).authorizationUrl(authCodeConfig.getAuthorizationUrl()).localAuthorizationUrlPath(callbackConfig.getLocalAuthorizePath()).localAuthorizationUrlResourceOwnerId("#[if (attributes.queryParams.resourceOwnerId != null) attributes.queryParams.resourceOwnerId else '']").state("#[if (attributes.queryParams.state != null) attributes.queryParams.state else '']").customParameters(config.getCustomParameters()).customParametersExtractorsExprs(this.getParameterExtractors(config));
        Pair<Optional<Flow>, Optional<Flow>> listenerFlows = this.getListenerFlows(config);
        listenerFlows.getFirst().ifPresent(flow -> dancerBuilder.beforeDanceCallback(this.beforeCallback(config, (Flow)flow)));
        listenerFlows.getSecond().ifPresent(flow -> dancerBuilder.afterDanceCallback(this.afterCallback(config, (Flow)flow)));
        AuthorizationCodeOAuthDancer dancer = (AuthorizationCodeOAuthDancer)dancerBuilder.build();
        if (this.started) {
            this.start(dancer);
        }
        return dancer;
    }

    private String getExternalCallback(HttpServer httpServer, OAuthCallbackConfig callbackConfig) {
        return callbackConfig.getExternalCallbackUrl().orElseGet(() -> {
            try {
                return new URL(httpServer.getProtocol().getScheme(), httpServer.getServerAddress().getIp(), httpServer.getServerAddress().getPort(), callbackConfig.getCallbackPath()).toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not derive a external callback url from <http:listener-config> '%s'", callbackConfig.getListenerConfig())), (Throwable)e);
            }
        });
    }

    private void start(AuthorizationCodeOAuthDancer dancer) throws MuleException {
        LifecycleUtils.initialiseIfNeeded(dancer, this.muleContext);
        LifecycleUtils.startIfNeeded(dancer);
    }

    private Supplier<ObjectStore> getObjectStoreSupplier(OAuthConfig config) {
        return () -> {
            String storeName = config.getStoreConfig().map(OAuthObjectStoreConfig::getObjectStoreName).orElse("_defaultPersistentObjectStore");
            return this.muleContext.getObjectStoreManager().getObjectStore(storeName);
        };
    }

    private Map<String, String> getParameterExtractors(OAuthConfig config) {
        return config.getParameterExtractors().entrySet().stream().collect(Collectors.toMap(entry -> ((Field)entry.getKey()).getName(), Map.Entry::getValue));
    }

    private Pair<Optional<Flow>, Optional<Flow>> getListenerFlows(OAuthConfig oauthConfig) {
        AuthCodeConfig config = oauthConfig.getAuthCodeConfig();
        try {
            return new Pair<Optional<Flow>, Optional<Flow>>(this.lookupFlow(config.getBefore()), this.lookupFlow(config.getAfter()));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not obtain 'before' and 'after' OAuth flows defined by config " + oauthConfig.getOwnerConfigName(), e));
        }
    }

    private Optional<Flow> lookupFlow(Optional<String> flowName) {
        return flowName.map(this::lookupFlow);
    }

    private Flow lookupFlow(String flowName) {
        Flow flow;
        try {
            flow = (Flow)this.muleContext.getRegistry().lookupFlowConstruct(flowName);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not obtain flow " + flowName, e));
        }
        if (flow == null) {
            throw new IllegalArgumentException("Flow " + flowName + " doesn't exist");
        }
        return flow;
    }

    private Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeCallback(OAuthConfig config, Flow flow) {
        return danceRequest -> {
            ImmutableAuthCodeRequest request = new ImmutableAuthCodeRequest(danceRequest.getResourceOwnerId(), danceRequest.getScopes(), danceRequest.getState().orElse(null), config.getCallbackConfig().getExternalCallbackUrl());
            InternalEvent event = this.runFlow(flow, this.createEvent(request, config, flow), config, "before");
            return paramKey -> DANCE_CALLBACK_EVENT_KEY.equals(paramKey) ? Optional.of(event) : Optional.empty();
        };
    }

    private BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterCallback(OAuthConfig config, Flow flow) {
        return (callbackContext, oauthContext) -> {
            AuthorizationCodeState state = ExtensionsOAuthUtils.toAuthorizationCodeState(config, oauthContext);
            InternalEvent event = (InternalEvent)callbackContext.getParameter(DANCE_CALLBACK_EVENT_KEY).orElseGet(() -> this.createEvent(state, config, flow));
            event = InternalEvent.builder(event).message(Message.builder().value(state).build()).build();
            this.runFlow(flow, event, config, "after");
        };
    }

    private InternalEvent createEvent(Object payload, OAuthConfig config, Flow flow) {
        return InternalEvent.builder(DefaultEventContext.create(flow, DefaultComponentLocation.fromSingleComponent(config.getOwnerConfigName()))).message(Message.builder().value(payload).build()).build();
    }

    private InternalEvent runFlow(Flow flow, InternalEvent event, OAuthConfig config, String callbackType) {
        try {
            return flow.process(event);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Error found while execution flow '%s' which is configured in the '%s' parameter of the '%s' config", flow.getName(), callbackType, config.getOwnerConfigName()), e));
        }
    }
}

