/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.oauth.OAuthCallbackValuesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.AuthCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthCallbackConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class OAuthConnectionProviderObjectBuilder<C>
extends DefaultConnectionProviderObjectBuilder<C>
implements Startable {
    private final ExtensionsOAuthManager oauthManager;
    private final AuthorizationCodeGrantType grantType;
    private final Map<Field, String> callbackValues;

    public OAuthConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionsOAuthManager oauthManager, ExtensionModel extensionModel, MuleContext muleContext) {
        super(providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, muleContext);
        this.oauthManager = oauthManager;
        this.grantType = this.getGrantType();
        this.callbackValues = this.getCallbackValues();
    }

    @Override
    public void start() throws MuleException {
        this.oauthManager.register(this.getInitialOAuthConfig());
    }

    @Override
    protected ConnectionProvider<C> doBuild(ResolverSetResult result) throws MuleException {
        ConnectionProvider provider = super.doBuild(result);
        OAuthConfig config = new OAuthConfig(this.ownerConfigName, this.buildAuthCodeConfig(result), this.buildOAuthCallbackConfig(result), this.buildOAuthObjectStoreConfig(result), this.grantType, this.getCustomParameters(result), this.getCallbackValues());
        provider = new OAuthConnectionProviderWrapper(provider, config, this.getCallbackValues(), this.oauthManager, this.reconnectionConfig);
        return provider;
    }

    @Override
    public Pair<ConnectionProvider<C>, ResolverSetResult> build(ValueResolvingContext context) throws MuleException {
        ResolverSetResult result = this.resolverSet.resolve(context);
        ConnectionProvider provider = super.doBuild(result);
        OAuthConfig config = new OAuthConfig(this.ownerConfigName, this.buildAuthCodeConfig(context.getEvent()), this.buildOAuthCallbackConfig(context.getEvent()), this.buildOAuthObjectStoreConfig(context.getEvent()), this.grantType, this.getCustomParameters(result), this.getCallbackValues());
        provider = new OAuthConnectionProviderWrapper(provider, config, this.getCallbackValues(), this.oauthManager, this.reconnectionConfig);
        return new Pair(provider, result);
    }

    private AuthCodeConfig buildAuthCodeConfig(ResolverSetResult result) throws MuleException {
        Map map = (Map)result.get("oauthAuthorizationCode");
        return this.buildAuthCodeConfig(map);
    }

    private AuthCodeConfig buildAuthCodeConfig(InternalEvent event) throws MuleException {
        Map map = (Map)this.resolverSet.getResolvers().get("oauthAuthorizationCode").resolve(ValueResolvingContext.from(event));
        return this.buildAuthCodeConfig(map);
    }

    private AuthCodeConfig buildAuthCodeConfig(Map<String, Object> map) {
        return new AuthCodeConfig((String)map.get("consumerKey"), (String)map.get("consumerSecret"), (String)map.get("authorizationUrl"), (String)map.get("accessTokenUrl"), (String)map.get("scopes"), (String)map.get("resourceOwnerId"), (String)map.get("before"), (String)map.get("after"));
    }

    private OAuthCallbackConfig buildOAuthCallbackConfig(InternalEvent event) throws MuleException {
        Map map = (Map)this.resolverSet.getResolvers().get("oauthCallbackConfig").resolve(ValueResolvingContext.from(event));
        return this.buildOAuthCallbackConfig(map);
    }

    private OAuthCallbackConfig buildOAuthCallbackConfig(ResolverSetResult result) throws MuleException {
        Map map = (Map)result.get("oauthCallbackConfig");
        return this.buildOAuthCallbackConfig(map);
    }

    private OAuthCallbackConfig buildOAuthCallbackConfig(Map<String, Object> map) {
        return new OAuthCallbackConfig((String)map.get("listenerConfig"), this.sanitizePath((String)map.get("callbackPath")), this.sanitizePath((String)map.get("authorizePath")), (String)map.get("externalCallbackUrl"));
    }

    private Optional<OAuthObjectStoreConfig> buildOAuthObjectStoreConfig(InternalEvent event) throws MuleException {
        ValueResolver<?> resolver = this.resolverSet.getResolvers().get("oauthStoreConfig");
        if (resolver == null) {
            return Optional.empty();
        }
        Map map = (Map)resolver.resolve(ValueResolvingContext.from(event));
        return map != null ? Optional.of(new OAuthObjectStoreConfig((String)map.get("objectStore"))) : Optional.empty();
    }

    private Optional<OAuthObjectStoreConfig> buildOAuthObjectStoreConfig(ResolverSetResult result) throws MuleException {
        Map map = (Map)result.get("oauthStoreConfig");
        return map != null ? Optional.of(new OAuthObjectStoreConfig((String)map.get("objectStore"))) : Optional.empty();
    }

    private Map<Field, String> getCallbackValues() {
        return this.providerModel.getModelProperty(OAuthCallbackValuesModelProperty.class).map(OAuthCallbackValuesModelProperty::getCallbackValues).orElseGet(Collections::emptyMap);
    }

    private Map<String, String> getCustomParameters(ResolverSetResult result) {
        HashMap<String, String> oauthParams = new HashMap<String, String>();
        this.withCustomParameters((parameter, property) -> oauthParams.put(property.getRequestAlias(), result.get(parameter.getName()).toString()));
        return oauthParams;
    }

    private void withCustomParameters(BiConsumer<ParameterModel, OAuthParameterModelProperty> delegate) {
        this.providerModel.getAllParameterModels().forEach(parameter -> parameter.getModelProperty(OAuthParameterModelProperty.class).ifPresent(property -> delegate.accept((ParameterModel)parameter, (OAuthParameterModelProperty)property)));
    }

    private Map<String, String> getCustomParameters(InternalEvent event) {
        HashMap<String, String> oauthParams = new HashMap<String, String>();
        this.withCustomParameters((parameter, property) -> {
            ValueResolver<?> resolver;
            String alias = property.getRequestAlias();
            if (StringUtils.isBlank((CharSequence)alias)) {
                alias = parameter.getName();
            }
            if ((resolver = this.resolverSet.getResolvers().get(alias)) != null) {
                try {
                    oauthParams.put(alias, this.resolveString(event, resolver));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(e);
                }
            }
        });
        return oauthParams;
    }

    private String resolveString(InternalEvent event, ValueResolver resolver) throws MuleException {
        Object value = resolver.resolve(ValueResolvingContext.from(event));
        return value != null ? StringMessageUtils.toString(value) : null;
    }

    private AuthorizationCodeGrantType getGrantType() {
        return this.providerModel.getModelProperty(OAuthModelProperty.class).map(p -> (AuthorizationCodeGrantType)p.getGrantTypes().get(0)).get();
    }

    private String sanitizePath(String path) {
        return !path.startsWith("/") ? "/" + path : path;
    }

    private OAuthConfig getInitialOAuthConfig() throws MuleException {
        InternalEvent initialiserEvent = MuleExtensionUtils.getInitialiserEvent();
        MapValueResolver mapResolver = this.staticOnly((MapValueResolver)this.resolverSet.getResolvers().get("oauthAuthorizationCode"));
        AuthCodeConfig authCodeConfig = this.buildAuthCodeConfig((Map<String, Object>)mapResolver.resolve(ValueResolvingContext.from(initialiserEvent)));
        Optional<OAuthObjectStoreConfig> storeConfig = this.buildOAuthObjectStoreConfig(initialiserEvent);
        mapResolver = this.staticOnly((MapValueResolver)this.resolverSet.getResolvers().get("oauthCallbackConfig"));
        OAuthCallbackConfig callbackConfig = this.buildOAuthCallbackConfig((Map<String, Object>)mapResolver.resolve(ValueResolvingContext.from(initialiserEvent)));
        return new OAuthConfig(this.ownerConfigName, authCodeConfig, callbackConfig, storeConfig, this.grantType, this.getCustomParameters(initialiserEvent), this.callbackValues);
    }

    private MapValueResolver staticOnly(MapValueResolver resolver) throws MuleException {
        ArrayList staticKeyResolvers = new ArrayList(resolver.getKeyResolvers().size());
        ArrayList staticValueResolvers = new ArrayList(resolver.getValueResolvers().size());
        Iterator keyResolvers = resolver.getKeyResolvers().iterator();
        Iterator valueResolvers = resolver.getValueResolvers().iterator();
        while (keyResolvers.hasNext() && valueResolvers.hasNext()) {
            ValueResolver keyResolver = keyResolvers.next();
            ValueResolver valueResolver = valueResolvers.next();
            if (keyResolver.isDynamic() || valueResolver.isDynamic()) continue;
            staticKeyResolvers.add(keyResolver);
            staticValueResolvers.add(valueResolver);
        }
        MapValueResolver result = new MapValueResolver(HashMap.class, staticKeyResolvers, staticValueResolvers, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(result, this.muleContext);
        return result;
    }
}

