/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.GroupValueSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.SingleValueSetter;
import org.mule.runtime.module.extension.internal.util.ValueSetter;

public abstract class ResolverSetBasedObjectBuilder<T>
implements ObjectBuilder<T>,
Initialisable {
    protected final ResolverSet resolverSet;
    private final List<ValueSetter> singleValueSetters;
    private final List<ValueSetter> groupValueSetters;
    @Inject
    private MuleContext muleContext;

    public ResolverSetBasedObjectBuilder(Class<?> prototypeClass, ResolverSet resolverSet) {
        this(prototypeClass, null, resolverSet);
    }

    public ResolverSetBasedObjectBuilder(Class<?> prototypeClass, ParameterizedModel model, ResolverSet resolverSet) {
        this.resolverSet = resolverSet;
        this.singleValueSetters = this.createSingleValueSetters(prototypeClass, resolverSet);
        this.groupValueSetters = model != null ? GroupValueSetter.settersFor(model) : ImmutableList.of();
    }

    @Override
    public boolean isDynamic() {
        return this.resolverSet.isDynamic();
    }

    @Override
    public T build(ValueResolvingContext context) throws MuleException {
        return this.build(this.resolverSet.resolve(context));
    }

    public T build(ResolverSetResult result) throws MuleException {
        T object = this.instantiateObject();
        this.populate(result, object);
        return object;
    }

    protected void populate(ResolverSetResult result, Object object) throws MuleException {
        this.setValues(object, result, this.groupValueSetters);
        this.setValues(object, result, this.singleValueSetters);
    }

    private List<ValueSetter> createSingleValueSetters(Class<?> prototypeClass, ResolverSet resolverSet) {
        return resolverSet.getResolvers().keySet().stream().map(parameterName -> IntrospectionUtils.getField(prototypeClass, parameterName).map(f -> new SingleValueSetter((String)parameterName, (Field)f))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toImmutableList());
    }

    private void setValues(Object target, ResolverSetResult result, List<ValueSetter> setters) throws MuleException {
        for (ValueSetter setter : setters) {
            setter.set(target, result);
        }
    }

    protected abstract T instantiateObject();

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.resolverSet, true, this.muleContext);
    }
}

