/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.ObjectNameHelper;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.internal.runtime.operation.ImmutableProcessorChainExecutor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public final class ProcessorChainValueResolver
implements ValueResolver<Chain> {
    private final MessageProcessorChain chain;
    private AtomicBoolean initialised = new AtomicBoolean(false);
    @Inject
    private MuleContext muleContext;

    public ProcessorChainValueResolver(MessageProcessorChain chain) {
        this.chain = chain;
    }

    public ProcessorChainValueResolver(List<Processor> processors) {
        this.chain = MessageProcessors.newChain(Optional.empty(), processors);
    }

    @Override
    public Chain resolve(ValueResolvingContext context) throws MuleException {
        this.initialiseIfNeeded();
        return new ImmutableProcessorChainExecutor(context.getEvent(), this.chain);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    private void initialiseIfNeeded() {
        if (!this.initialised.get()) {
            try {
                this.muleContext.getRegistry().registerObject(new ObjectNameHelper(this.muleContext).getUniqueName(""), this.chain);
                LifecycleUtils.initialiseIfNeeded(this.chain, this.muleContext);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not register nested operation message processor"), (Throwable)e);
            }
            this.initialised.set(true);
        }
    }
}

