/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class SourceConnectionManager {
    private final ConnectionManager connectionManager;
    private final Map<Reference<Object>, ConnectionHandler<Object>> connections = new ConcurrentHashMap<Reference<Object>, ConnectionHandler<Object>>();

    SourceConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    <T> T getConnection(ConfigurationInstance config) throws ConnectionException {
        ConnectionHandler connectionHandler = this.connectionManager.getConnection(config.getValue());
        Object connection = connectionHandler.getConnection();
        this.connections.put(new Reference(connection), connectionHandler);
        return (T)connection;
    }

    void release(Object connection) {
        ConnectionHandler<Object> connectionHandler = this.connections.remove(new Reference<Object>(connection));
        if (connectionHandler != null) {
            connectionHandler.release();
        }
    }

    void invalidate(Object connection) {
        ConnectionHandler<Object> connectionHandler = this.connections.remove(new Reference<Object>(connection));
        if (connectionHandler != null) {
            connectionHandler.invalidate();
        }
    }

    ConnectionValidationResult testConnectivity(ConnectionProvider<?> connectionProvider) {
        return this.connectionManager.testConnectivity(connectionProvider);
    }

    <T> ConnectionHandler<T> getConnectionHandler(T connection) {
        return this.connections.get(new Reference<T>(connection));
    }
}

