/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterResolverTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.property.LiteralModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterResolverTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.TypedValueTypeModelProperty;
import org.reflections.ReflectionUtils;
import org.springframework.core.ResolvableType;

public final class IntrospectionUtils {
    private IntrospectionUtils() {
    }

    public static MetadataType getMetadataType(Class<?> type, ClassTypeLoader typeLoader) {
        return typeLoader.load(ResolvableType.forClass(type).getType());
    }

    public static DataType toDataType(MetadataType metadataType) {
        final Class type = ExtensionMetadataTypeUtils.getType(metadataType).orElse(null);
        if (type == null) {
            return DataType.fromType(Object.class);
        }
        final Reference dataType = new Reference();
        metadataType.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                dataType.set(DataType.fromType(type));
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                Class itemClass = ExtensionMetadataTypeUtils.getType(arrayType.getType()).get();
                if (Collection.class.isAssignableFrom(type)) {
                    dataType.set(DataType.builder().collectionType(type).itemType(itemClass).build());
                } else if (Iterator.class.isAssignableFrom(type)) {
                    dataType.set(DataType.builder().streamType(type).itemType(itemClass).build());
                } else {
                    this.defaultVisit(arrayType);
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (Map.class.isAssignableFrom(type)) {
                    dataType.set(DataType.builder().mapType(type).keyType(String.class).valueType(objectType.getOpenRestriction().map(restriction -> {
                        if (restriction.getAnnotation(TypedValueTypeAnnotation.class).isPresent()) {
                            return TypedValue.class;
                        }
                        return ExtensionMetadataTypeUtils.getType(restriction).get();
                    }).orElse(Object.class)).build());
                } else {
                    this.defaultVisit(objectType);
                }
            }
        });
        return (DataType)dataType.get();
    }

    public static MetadataType getMethodReturnType(Method method, ClassTypeLoader typeLoader) {
        return IntrospectionUtils.getReturnType(IntrospectionUtils.getMethodType(method), typeLoader);
    }

    public static MetadataType getSourceReturnType(Type returnType, ClassTypeLoader typeLoader) {
        return IntrospectionUtils.getReturnType(ResolvableType.forType((Type)returnType), typeLoader);
    }

    private static MetadataType getReturnType(ResolvableType returnType, ClassTypeLoader typeLoader) {
        ResolvableType itemType;
        Type type = returnType.getType();
        Class rawClass = returnType.getRawClass();
        if (rawClass.equals(Result.class)) {
            ResolvableType genericType = returnType.getGenerics()[0];
            type = genericType.getRawClass() != null ? genericType.getType() : null;
        }
        if (IntrospectionUtils.isPagingProvider(returnType)) {
            itemType = returnType.getGenerics()[1];
            if (Result.class.equals((Object)itemType.getRawClass())) {
                return IntrospectionUtils.returnListOfMessagesType(returnType, typeLoader, itemType);
            }
            return IntrospectionUtils.typeBuilder().arrayType().of(typeLoader.load(itemType.getType())).with(new ClassInformationAnnotation(rawClass)).build();
        }
        if (ParameterResolver.class.isAssignableFrom(rawClass) || TypedValue.class.isAssignableFrom(rawClass) || Literal.class.isAssignableFrom(rawClass)) {
            type = returnType.getGenerics()[0].getType();
        }
        if (IntrospectionUtils.isCollection(returnType) && Result.class.equals((Object)(itemType = returnType.getGenerics()[0]).getRawClass())) {
            return IntrospectionUtils.returnListOfMessagesType(returnType, typeLoader, itemType);
        }
        return type != null ? typeLoader.load(type) : IntrospectionUtils.typeBuilder().anyType().build();
    }

    private static MetadataType returnListOfMessagesType(ResolvableType returnType, ClassTypeLoader typeLoader, ResolvableType itemType) {
        ResolvableType genericType = itemType.getGenerics()[0];
        Class rawClass = genericType.getRawClass();
        if (rawClass != null && TypedValue.class.isAssignableFrom(rawClass)) {
            genericType = genericType.getGenerics()[0];
        }
        MetadataType outputType = rawClass != null ? typeLoader.load(genericType.getType()) : IntrospectionUtils.typeBuilder().anyType().build();
        genericType = itemType.getGenerics()[1];
        MetadataType attributesType = rawClass != null ? typeLoader.load(genericType.getType()) : IntrospectionUtils.typeBuilder().voidType().build();
        return IntrospectionUtils.typeBuilder().arrayType().of(new MessageMetadataTypeBuilder().payload(outputType).attributes(attributesType).build()).with(new ClassInformationAnnotation(returnType.getRawClass())).build();
    }

    private static boolean isCollection(ResolvableType type) {
        return Collection.class.isAssignableFrom(type.getRawClass());
    }

    public static MetadataType getMethodReturnAttributesType(Method method, ClassTypeLoader typeLoader) {
        ResolvableType itemType;
        ResolvableType genericType;
        ResolvableType outputType = IntrospectionUtils.getMethodType(method);
        Type type = null;
        if (Result.class.equals((Object)outputType.getRawClass()) && (genericType = outputType.getGenerics()[1]).getRawClass() != null) {
            type = genericType.getType();
        }
        if (IntrospectionUtils.isPagingProvider(outputType) && Result.class.equals((Object)(itemType = outputType.getGenerics()[1]).getRawClass())) {
            type = null;
        }
        if (IntrospectionUtils.isCollection(outputType) && Result.class.equals((Object)(itemType = outputType.getGenerics()[0]).getRawClass())) {
            type = null;
        }
        return type != null ? typeLoader.load(type) : IntrospectionUtils.typeBuilder().voidType().build();
    }

    public static List<MetadataType> getGenerics(Type type, ClassTypeLoader typeLoader) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] generics = parameterizedType.getActualTypeArguments();
            return Stream.of(generics).map(typeLoader::load).collect(java.util.stream.Collectors.toList());
        }
        return new LinkedList<MetadataType>();
    }

    private static ResolvableType getMethodType(Method method) {
        Preconditions.checkArgument(method != null, "Can't introspect a null method");
        return ResolvableType.forMethodReturnType((Method)method);
    }

    public static boolean isLifecycle(Class<?> type) {
        return Initialisable.class.isAssignableFrom(type) || Startable.class.isAssignableFrom(type) || Stoppable.class.isAssignableFrom(type) || Disposable.class.isAssignableFrom(type);
    }

    private static boolean isPagingProvider(ResolvableType type) {
        return PagingProvider.class.isAssignableFrom(type.getRawClass());
    }

    private static BaseTypeBuilder typeBuilder() {
        return BaseTypeBuilder.create(MetadataFormat.JAVA);
    }

    public static MetadataType[] getMethodArgumentTypes(Method method, ClassTypeLoader typeLoader) {
        Preconditions.checkArgument(method != null, "Can't introspect a null method");
        Object[] parameters = method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            return new MetadataType[0];
        }
        MetadataType[] types = new MetadataType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            ResolvableType type = ResolvableType.forMethodParameter((Method)method, (int)i);
            types[i] = typeLoader.load(type.getType());
        }
        return types;
    }

    public static MetadataType getFieldMetadataType(Field field, ClassTypeLoader typeLoader) {
        Preconditions.checkArgument(field != null, "Can't introspect a null field");
        return typeLoader.load(ResolvableType.forField((Field)field).getType());
    }

    public static java.util.Optional<Field> getFieldByNameOrAlias(Class<?> clazz, String nameOrAlias) {
        java.util.Optional<Field> field = IntrospectionUtils.getField(clazz, nameOrAlias);
        if (!field.isPresent()) {
            field = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[]{f -> IntrospectionUtils.getAlias(f).equals(nameOrAlias)}).stream().findFirst();
        }
        return field;
    }

    public static java.util.Optional<Field> getField(Class<?> clazz, ParameterModel parameterModel) {
        return IntrospectionUtils.getField(clazz, IntrospectionUtils.getMemberName(parameterModel, parameterModel.getName()));
    }

    public static java.util.Optional<Field> getField(Class<?> clazz, ParameterDeclaration parameterDeclaration) {
        return IntrospectionUtils.getField(clazz, MuleExtensionAnnotationParser.getMemberName(parameterDeclaration, parameterDeclaration.getName()));
    }

    public static java.util.Optional<Field> getField(Class<?> clazz, String name) {
        Set candidates = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)name)});
        return CollectionUtils.isEmpty((Collection)candidates) ? java.util.Optional.empty() : java.util.Optional.of(candidates.iterator().next());
    }

    public static Object getFieldValue(Object object, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        java.util.Optional<Field> fieldOptional = IntrospectionUtils.getField(object.getClass(), fieldName);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            field.setAccessible(true);
            return field.get(object);
        }
        throw new NoSuchFieldException();
    }

    public static String getMemberName(EnrichableModel enrichableModel, String defaultName) {
        return enrichableModel.getModelProperty(DeclaringMemberModelProperty.class).map(p -> p.getDeclaringField().getName()).orElse(defaultName);
    }

    public static boolean hasDefaultConstructor(Class<?> clazz) {
        return ClassUtils.getConstructor(clazz, new Class[0]) != null;
    }

    public static List<Class<?>> getInterfaceGenerics(Class<?> type, Class<?> implementedInterface) {
        ResolvableType interfaceType = null;
        Class<?> searchClass = type;
        while (!Object.class.equals(searchClass)) {
            for (ResolvableType iType : ResolvableType.forClass(searchClass).getInterfaces()) {
                if (!implementedInterface.isAssignableFrom(iType.getRawClass())) continue;
                interfaceType = iType;
                break;
            }
            if (interfaceType != null) break;
            searchClass = searchClass.getSuperclass();
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException(String.format("Class '%s' does not implement the '%s' interface", type.getName(), implementedInterface.getName()));
        }
        List<Class<?>> generics = IntrospectionUtils.toRawClasses(interfaceType.getGenerics());
        if (generics.stream().anyMatch(c -> c == null)) {
            return IntrospectionUtils.findGenericsInSuperHierarchy(type);
        }
        return generics;
    }

    public static List<Class<?>> findGenericsInSuperHierarchy(Class<?> type) {
        if (Object.class.equals(type)) {
            return ImmutableList.of();
        }
        Class<?> superClass = type.getSuperclass();
        List<Type> generics = IntrospectionUtils.getSuperClassGenerics(type, superClass);
        if (CollectionUtils.isEmpty(generics) && !Object.class.equals(superClass)) {
            return IntrospectionUtils.findGenericsInSuperHierarchy(superClass);
        }
        return generics;
    }

    private static List<Class<?>> toRawClasses(ResolvableType ... types) {
        return Arrays.stream(types).map(ResolvableType::getRawClass).collect(java.util.stream.Collectors.toList());
    }

    public static List<Type> getSuperClassGenerics(Class<?> type, Class<?> superClass) {
        if (!superClass.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Class '%s' does not extend the '%s' class", type.getName(), superClass.getName()));
        }
        Class<?> searchClass = type;
        while (!Object.class.equals(searchClass)) {
            Type superType;
            if (searchClass.getSuperclass().equals(superClass) && (superType = searchClass.getGenericSuperclass()) instanceof ParameterizedType) {
                return Arrays.stream(((ParameterizedType)superType).getActualTypeArguments()).collect(java.util.stream.Collectors.toList());
            }
            searchClass = searchClass.getSuperclass();
        }
        return new LinkedList<Type>();
    }

    public static void checkInstantiable(Class<?> declaringClass) {
        IntrospectionUtils.checkInstantiable(declaringClass, true);
    }

    public static void checkInstantiable(Class<?> declaringClass, boolean requireDefaultConstructor) {
        if (!IntrospectionUtils.isInstantiable(declaringClass, requireDefaultConstructor)) {
            throw new IllegalArgumentException(String.format("Class %s cannot be instantiated.", declaringClass));
        }
    }

    public static boolean isInstantiable(MetadataType type) {
        return ExtensionMetadataTypeUtils.getType(type).map(IntrospectionUtils::isInstantiable).orElse(false);
    }

    public static boolean isInstantiable(Class<?> declaringClass) {
        return IntrospectionUtils.isInstantiable(declaringClass, true);
    }

    public static boolean isInstantiable(Class<?> declaringClass, boolean requireDefaultConstructor) {
        return declaringClass != null && (!requireDefaultConstructor || IntrospectionUtils.hasDefaultConstructor(declaringClass)) && !declaringClass.isInterface() && !Modifier.isAbstract(declaringClass.getModifiers());
    }

    public static boolean assignableFromAny(Class<?> type, Collection<Class<?>> matchingTypes) {
        return matchingTypes.stream().anyMatch(t -> t.isAssignableFrom(type));
    }

    public static boolean isRequired(AccessibleObject object) {
        return object.getAnnotation(Optional.class) == null;
    }

    public static boolean isRequired(ParameterModel parameterModel, boolean forceOptional) {
        return !forceOptional && parameterModel.isRequired();
    }

    public static boolean isVoid(Method method) {
        return IntrospectionUtils.isVoid(method.getReturnType());
    }

    public static boolean isVoid(ComponentModel componentModel) {
        return componentModel instanceof HasOutputModel && ((HasOutputModel)((Object)componentModel)).getOutput().getType() instanceof VoidType;
    }

    private static boolean isVoid(Class<?> type) {
        return type.equals(Void.TYPE) || type.equals(Void.class);
    }

    public static Collection<Method> getApiMethods(Class<?> declaringClass) {
        return IntrospectionUtils.getMethodsStream(declaringClass).filter(method -> !method.isAnnotationPresent(Ignore.class) && !IntrospectionUtils.isLifecycleMethod(method)).collect(java.util.stream.Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean isLifecycleMethod(Method method) {
        return IntrospectionUtils.isLifecycleMethod(method, Initialisable.class, "initialise") || IntrospectionUtils.isLifecycleMethod(method, Startable.class, "start") || IntrospectionUtils.isLifecycleMethod(method, Stoppable.class, "stop") || IntrospectionUtils.isLifecycleMethod(method, Disposable.class, "dispose");
    }

    private static boolean isLifecycleMethod(Method method, Class<?> lifecycleClass, String lifecycleMethodName) {
        return lifecycleClass.isAssignableFrom(method.getDeclaringClass()) && method.getName().equals(lifecycleMethodName);
    }

    public static Collection<Method> getMethodsAnnotatedWith(Class<?> declaringClass, Class<? extends Annotation> annotationType) {
        return IntrospectionUtils.getMethodsAnnotatedWith(declaringClass, annotationType, true);
    }

    public static Collection<Method> getMethodsAnnotatedWith(Class<?> declaringClass, Class<? extends Annotation> annotationType, boolean superClasses) {
        return IntrospectionUtils.getMethodsStream(declaringClass, superClasses).filter(method -> method.getAnnotation(annotationType) != null).collect(java.util.stream.Collectors.toCollection(LinkedHashSet::new));
    }

    private static Stream<Method> getMethodsStream(Class<?> declaringClass) {
        return IntrospectionUtils.getMethodsStream(declaringClass, true);
    }

    private static Stream<Method> getMethodsStream(Class<?> declaringClass, boolean superClasses) {
        Stream<Method> methodStream = superClasses ? ReflectionUtils.getAllSuperTypes(declaringClass, (Predicate[])new Predicate[0]).stream().filter(type -> !type.isInterface()).flatMap(type -> Stream.of(type.getDeclaredMethods())) : Stream.of(declaringClass.getDeclaredMethods());
        return methodStream.filter(method -> Modifier.isPublic(method.getModifiers()));
    }

    public static List<Field> getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return IntrospectionUtils.getDescendingHierarchy(clazz).stream().flatMap(type -> Arrays.stream(type.getDeclaredFields())).filter(field -> field.getAnnotation(annotationType) != null).collect(Collectors.toImmutableList());
    }

    public static List<Field> getFields(Class<?> clazz) {
        try {
            return IntrospectionUtils.getFieldsStream(clazz).collect(Collectors.toImmutableList());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<Field> getFieldsStream(Class<?> clazz) {
        try {
            return IntrospectionUtils.getDescendingHierarchy(clazz).stream().flatMap(type -> Arrays.stream(type.getDeclaredFields()));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Field> getFieldsOfType(Class<?> introspectedType, Class fieldType) {
        return IntrospectionUtils.getFieldsStream(introspectedType).filter(f -> fieldType.isAssignableFrom(f.getType()) && !Modifier.isStatic(f.getModifiers())).collect(java.util.stream.Collectors.toList());
    }

    public static <T extends AnnotatedElement & Member> String getAlias(T element) {
        Alias alias = element.getAnnotation(Alias.class);
        return alias != null ? alias.value() : ((Member)element).getName();
    }

    private static List<Class<?>> getDescendingHierarchy(Class<?> type) {
        LinkedList types = new LinkedList();
        types.add(type);
        for (type = type.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
            types.add(0, type);
        }
        return ImmutableList.copyOf(types);
    }

    public static Collection<Field> getExposedFields(Class<?> extensionType) {
        List<Field> allFields = IntrospectionUtils.getAnnotatedFields(extensionType, org.mule.runtime.extension.api.annotation.param.Parameter.class);
        if (!allFields.isEmpty()) {
            return allFields;
        }
        return IntrospectionUtils.getFieldsWithGetters(extensionType);
    }

    public static Set<Field> getFieldsWithGetters(Class<?> extensionType) {
        return IntrospectionUtils.getPropertyDescriptors(extensionType).stream().filter(p -> p.getReadMethod() != null).map(p -> IntrospectionUtils.getField(extensionType, p.getName())).filter(java.util.Optional::isPresent).map(java.util.Optional::get).collect(java.util.stream.Collectors.toSet());
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(Class<?> extensionType) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(extensionType).getPropertyDescriptors();
            return Arrays.asList(propertyDescriptors);
        }
        catch (IntrospectionException e) {
            throw new IllegalModelDefinitionException("Could not introspect POJO: " + extensionType.getName(), e);
        }
    }

    public static ExpressionSupport getExpressionSupport(AnnotatedElement object) {
        return IntrospectionUtils.getExpressionSupport(object.getAnnotation(Expression.class));
    }

    public static ExpressionSupport getExpressionSupport(Expression expressionAnnotation) {
        return expressionAnnotation != null ? expressionAnnotation.value() : ExpressionSupport.SUPPORTED;
    }

    public static String getSourceName(Class<? extends Source> sourceType) {
        Alias alias = sourceType.getAnnotation(Alias.class);
        if (alias != null) {
            return alias.value();
        }
        return sourceType.getSimpleName();
    }

    public static <T extends Annotation> T getAnnotation(Class<?> annotatedClass, Class<T> annotationClass) {
        T annotation = annotatedClass.getAnnotation(annotationClass);
        for (Class<?> superClass = annotatedClass.getSuperclass(); annotation == null && superClass != null && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            annotation = superClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    public static Set<Class<?>> getParameterClasses(ExtensionModel extensionModel, final ClassLoader extensionClassLoader) {
        final HashSet parameterClasses = new HashSet();
        new ExtensionWalker(){

            @Override
            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                parameterClasses.addAll(IntrospectionUtils.collectRelativeClasses(model.getType(), extensionClassLoader));
            }
        }.walk(extensionModel);
        return parameterClasses;
    }

    public static Set<Class<?>> collectRelativeClasses(MetadataType type, final ClassLoader extensionClassLoader) {
        final HashSet relativeClasses = new HashSet();
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept(this);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.getMetadataFormat() != MetadataFormat.JAVA) {
                    return;
                }
                Class clazz = ExtensionMetadataTypeUtils.getType(objectType).orElse(null);
                if (clazz == null || relativeClasses.contains(clazz)) {
                    return;
                }
                java.util.Optional<ClassInformationAnnotation> classInformation = objectType.getAnnotation(ClassInformationAnnotation.class);
                if (classInformation.isPresent()) {
                    classInformation.get().getGenericTypes().forEach(generic -> relativeClasses.add(IntrospectionUtils.loadClass(generic, extensionClassLoader)));
                }
                relativeClasses.add(clazz);
                objectType.getFields().stream().forEach(objectFieldType -> objectFieldType.accept(this));
                objectType.getOpenRestriction().ifPresent(t -> t.accept(this));
            }

            @Override
            public void visitString(StringType stringType) {
                if (stringType.getMetadataFormat() == MetadataFormat.JAVA && MetadataTypeUtils.isEnum(stringType)) {
                    ExtensionMetadataTypeUtils.getType(stringType).ifPresent(relativeClasses::add);
                }
            }
        });
        return relativeClasses;
    }

    private static Class loadClass(String name, ClassLoader extensionClassloader) {
        try {
            return ClassUtils.loadClass(name, extensionClassloader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isMultiLevelMetadataKeyId(Set<Class<? extends Annotation>> annotations, MetadataType parameterType) {
        return annotations.contains(MetadataKeyId.class) && MetadataTypeUtils.isObjectType(parameterType);
    }

    public static boolean isParameterContainer(Set<Class<? extends Annotation>> annotations, MetadataType parameterType) {
        return annotations.contains(ParameterGroup.class) || IntrospectionUtils.isMultiLevelMetadataKeyId(annotations, parameterType);
    }

    public static java.util.Optional<AnnotatedElement> getAnnotatedElement(BaseDeclaration<?> declaration) {
        java.util.Optional<DeclaringMemberModelProperty> declaringMember = declaration.getModelProperty(DeclaringMemberModelProperty.class);
        java.util.Optional<ImplementingParameterModelProperty> implementingParameter = declaration.getModelProperty(ImplementingParameterModelProperty.class);
        AnnotatedElement annotatedElement = null;
        if (declaringMember.isPresent()) {
            annotatedElement = declaringMember.get().getDeclaringField();
        }
        if (implementingParameter.isPresent()) {
            annotatedElement = implementingParameter.get().getParameter();
        }
        return java.util.Optional.ofNullable(annotatedElement);
    }

    public static String getContainerName(AnnotatedElement container) {
        if (container instanceof Field) {
            return ((Field)container).getName();
        }
        if (container instanceof Parameter) {
            return ((Parameter)container).getName();
        }
        throw new IllegalArgumentException("Unknown container type");
    }

    public static String getGroupModelContainerName(ParameterGroupModel groupModel) {
        return groupModel.getModelProperty(ParameterGroupModelProperty.class).map(modelProperty -> IntrospectionUtils.getContainerName(modelProperty.getDescriptor().getContainer())).orElse(groupModel.getName());
    }

    public static String getImplementingName(ParameterDeclaration parameterDeclaration) {
        return IntrospectionUtils.getImplementingName(parameterDeclaration.getName(), () -> parameterDeclaration.getModelProperty(ImplementingParameterModelProperty.class), () -> parameterDeclaration.getModelProperty(DeclaringMemberModelProperty.class));
    }

    public static String getImplementingName(ParameterModel parameterModel) {
        return IntrospectionUtils.getImplementingName(parameterModel.getName(), () -> parameterModel.getModelProperty(ImplementingParameterModelProperty.class), () -> parameterModel.getModelProperty(DeclaringMemberModelProperty.class));
    }

    private static String getImplementingName(String originalName, Supplier<java.util.Optional<ImplementingParameterModelProperty>> implementingParameter, Supplier<java.util.Optional<DeclaringMemberModelProperty>> declaringMember) {
        java.util.Optional<ImplementingParameterModelProperty> parameter = implementingParameter.get();
        if (parameter.isPresent()) {
            return parameter.get().getParameter().getName();
        }
        java.util.Optional<DeclaringMemberModelProperty> field = declaringMember.get();
        if (field.isPresent()) {
            return field.get().getDeclaringField().getName();
        }
        return originalName;
    }

    public static boolean isParameterResolver(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().anyMatch(modelProperty -> modelProperty instanceof ParameterResolverTypeModelProperty);
    }

    public static boolean isParameterResolver(MetadataType metadataType) {
        return metadataType.getAnnotation(ParameterResolverTypeAnnotation.class).isPresent();
    }

    public static boolean isLiteral(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().anyMatch(modelProperty -> modelProperty instanceof LiteralModelProperty);
    }

    public static boolean isLiteral(MetadataType metadataType) {
        return metadataType.getAnnotation(LiteralTypeAnnotation.class).isPresent();
    }

    public static boolean isTypedValue(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().anyMatch(modelProperty -> modelProperty instanceof TypedValueTypeModelProperty);
    }

    public static boolean isTypedValue(MetadataType metadataType) {
        return metadataType.getAnnotation(TypedValueTypeAnnotation.class).isPresent();
    }

    public static java.util.Optional<ConnectionProviderModel> getConnectionProviderModel(Class<? extends ConnectionProvider> connectionProvider, List<ConnectionProviderModel> allConnectionProviders) {
        for (ConnectionProviderModel providerModel : allConnectionProviders) {
            ImplementingTypeModelProperty property;
            java.util.Optional<ImplementingTypeModelProperty> modelProperty = providerModel.getModelProperty(ImplementingTypeModelProperty.class);
            if (!modelProperty.isPresent() || !(property = modelProperty.get()).getType().equals(connectionProvider)) continue;
            return java.util.Optional.of(providerModel);
        }
        return java.util.Optional.empty();
    }
}

