/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.util.ReflectionUtils;

public class ValueProviderFactory {
    private final ValueProviderFactoryModelProperty factoryModelProperty;
    private final ParameterValueResolver parameterValueResolver;
    private final Supplier<Object> connectionSupplier;
    private final Supplier<Object> configurationSupplier;
    private final Field connectionField;
    private final Field configField;
    private final MuleContext muleContext;

    public ValueProviderFactory(ValueProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, Field connectionField, Field configField, MuleContext muleContext) {
        this.factoryModelProperty = factoryModelProperty;
        this.parameterValueResolver = parameterValueResolver;
        this.connectionSupplier = connectionSupplier;
        this.configurationSupplier = configurationSupplier;
        this.connectionField = connectionField;
        this.configField = configField;
        this.muleContext = muleContext;
    }

    ValueProvider createValueProvider() throws ValueResolvingException {
        Class<? extends ValueProvider> resolverClass = this.factoryModelProperty.getValueProvider();
        try {
            ValueProvider resolver = ClassUtils.instantiateClass(resolverClass, new Object[0]);
            LifecycleUtils.initialiseIfNeeded(resolver, true, this.muleContext);
            for (String requiredParam : this.factoryModelProperty.getRequiredParameters()) {
                Object parameterValue = this.parameterValueResolver.getParameterValue(requiredParam);
                ValueProviderFactory.injectValueIntoField(resolver, parameterValue, requiredParam);
            }
            if (this.factoryModelProperty.usesConnection()) {
                ValueProviderFactory.injectValueIntoField(resolver, this.connectionSupplier.get(), this.connectionField);
            }
            if (this.factoryModelProperty.usesConfig()) {
                ValueProviderFactory.injectValueIntoField(resolver, this.configurationSupplier.get(), this.configField);
            }
            return resolver;
        }
        catch (Exception e) {
            throw new ValueResolvingException("An error occurred trying to create a ValueProvider", "UNKNOWN", (Throwable)e);
        }
    }

    private static void injectValueIntoField(ValueProvider fieldContainer, Object valueToInject, String requiredParamName) {
        Optional<Field> optionalField = IntrospectionUtils.getField(fieldContainer.getClass(), requiredParamName);
        if (optionalField.isPresent()) {
            Field field = optionalField.get();
            ValueProviderFactory.injectValueIntoField(fieldContainer, valueToInject, field);
        }
    }

    private static void injectValueIntoField(ValueProvider fieldContainer, Object valueToInject, Field field) {
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)fieldContainer, (Object)valueToInject);
    }
}

