/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.util.Collection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResponseCompletionHandler
extends EmptyCompletionHandler<WriteResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseResponseCompletionHandler.class);
    private static final String MULTIPART_CONTENT_TYPE_FORMAT = "%s; %s=\"%s\"";

    protected HttpResponsePacket buildHttpResponsePacket(HttpRequestPacket sourceRequest, HttpResponse httpResponse) {
        HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)sourceRequest).status(httpResponse.getStatusCode()).reasonPhrase(httpResponse.getReasonPhrase());
        Collection<String> allHeaders = httpResponse.getHeaderNames();
        for (String headerName : allHeaders) {
            Collection<String> values = httpResponse.getHeaderValues(headerName);
            for (String value : values) {
                responsePacketBuilder.header(headerName, value);
            }
        }
        if (httpResponse.getEntity().isComposed()) {
            String contentType = httpResponse.getHeaderValueIgnoreCase("Content-Type");
            if (contentType == null) {
                responsePacketBuilder.header("Content-Type", String.format(MULTIPART_CONTENT_TYPE_FORMAT, "multipart/form-data", "boundary", UUID.getUUID()));
            } else if (!contentType.contains("boundary")) {
                responsePacketBuilder.removeHeader("Content-Type");
                responsePacketBuilder.header("Content-Type", String.format(MULTIPART_CONTENT_TYPE_FORMAT, contentType, "boundary", UUID.getUUID()));
            }
        }
        HttpResponsePacket httpResponsePacket = responsePacketBuilder.build();
        httpResponsePacket.setProtocol(sourceRequest.getProtocol());
        if (httpResponse.getHeaderValueIgnoreCase("Transfer-Encoding") != null) {
            httpResponsePacket.setChunked(true);
        }
        if ("close".equalsIgnoreCase(httpResponsePacket.getHeader("Connection"))) {
            httpResponsePacket.getProcessingState().setKeepAlive(false);
        }
        return httpResponsePacket;
    }

    public void cancelled() {
        LOGGER.warn("HTTP response sending task was cancelled");
    }

    public void failed(Throwable throwable) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(String.format("HTTP response sending task failed with error: %s", throwable.getMessage()));
        }
    }
}

