/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;

public class ResponseStreamingCompletionHandler
extends BaseResponseCompletionHandler {
    private final MemoryManager memoryManager;
    private final FilterChainContext ctx;
    private final HttpResponsePacket httpResponsePacket;
    private final InputStream inputStream;
    private final ResponseStatusCallback responseStatusCallback;
    private volatile boolean isDone;

    public ResponseStreamingCompletionHandler(FilterChainContext ctx, HttpRequestPacket request, HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
        Preconditions.checkArgument((boolean)httpResponse.getEntity().isStreaming(), (Object)"HTTP response entity must be stream based");
        this.ctx = ctx;
        this.httpResponsePacket = this.buildHttpResponsePacket(request, httpResponse);
        this.inputStream = httpResponse.getEntity().getContent();
        this.memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        this.responseStatusCallback = responseStatusCallback;
    }

    public void start() throws IOException {
        this.sendInputStreamChunk();
    }

    public void sendInputStreamChunk() throws IOException {
        HttpTrailer content;
        int length;
        int offset;
        Buffer buffer = this.memoryManager.allocate(8192);
        byte[] bufferByteArray = buffer.array();
        int bytesRead = this.inputStream.read(bufferByteArray, offset = buffer.arrayOffset(), length = buffer.remaining());
        if (bytesRead == -1) {
            content = this.httpResponsePacket.httpTrailerBuilder().build();
            this.isDone = true;
        } else {
            buffer.limit(bytesRead);
            content = this.httpResponsePacket.httpContentBuilder().content(buffer).build();
        }
        this.ctx.write((Object)content, (CompletionHandler)this);
    }

    public void completed(WriteResult result) {
        try {
            if (!this.isDone) {
                this.sendInputStreamChunk();
                if (this.isDone && !this.httpResponsePacket.isChunked()) {
                    this.doComplete();
                }
            } else {
                this.doComplete();
            }
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    private void doComplete() {
        this.close();
        this.responseStatusCallback.responseSendSuccessfully();
        this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        this.resume();
    }

    @Override
    public void cancelled() {
        super.cancelled();
        this.close();
        this.responseStatusCallback.responseSendFailure(new DefaultMuleException(CoreMessages.createStaticMessage("Http response sending task was cancelled")));
        this.resume();
    }

    @Override
    public void failed(Throwable throwable) {
        super.failed(throwable);
        this.close();
        this.resume();
    }

    private void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resume() {
        this.ctx.resume(this.ctx.getStopAction());
    }
}

