/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.xml.XmlTypeLoader;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.exception.SoapServiceException;
import org.mule.service.soap.generator.EmptyRequestGenerator;
import org.mule.service.soap.generator.attachment.AttachmentRequestEnricher;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.util.XmlTransformationException;
import org.mule.service.soap.util.XmlTransformationUtils;

public final class SoapRequestGenerator {
    private final EmptyRequestGenerator emptyRequestGenerator;
    private final AttachmentRequestEnricher requestEnricher;

    public SoapRequestGenerator(AttachmentRequestEnricher requestEnricher, ServiceDefinition definition, XmlTypeLoader loader) {
        this.requestEnricher = requestEnricher;
        this.emptyRequestGenerator = new EmptyRequestGenerator(definition, loader);
    }

    public XMLStreamReader generate(String operation, String body2, Map<String, SoapAttachment> attachments) {
        if (StringUtils.isBlank((CharSequence)body2)) {
            body2 = this.emptyRequestGenerator.generateRequest(operation);
        }
        if (!attachments.isEmpty()) {
            body2 = this.requestEnricher.enrichRequest(body2, attachments);
        }
        try {
            return XmlTransformationUtils.stringToXmlStreamReader(body2);
        }
        catch (XmlTransformationException e) {
            throw new SoapServiceException("Error generating SOAP request", e);
        }
    }
}

