/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.service.soap.introspection.OperationDefinition;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.metadata.NodeMetadataResolver;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;

abstract class BodyMetadataResolver
extends NodeMetadataResolver {
    BodyMetadataResolver(ServiceDefinition definition, TypeLoader loader, Function<OperationDefinition, Optional<Part>> partRetriever) {
        super(definition, loader, partRetriever);
    }

    @Override
    public MetadataType getMetadata(String operationName) throws MetadataResolvingException {
        Part bodyPart = this.getBodyPart(this.definition.getOperation(operationName));
        MetadataType bodyType = this.buildPartMetadataType(bodyPart);
        List<ObjectFieldType> attachmentFields = SoapServiceMetadataTypeUtils.getAttachmentFields(bodyType);
        return this.filterAttachmentsFromBodyType(bodyType, attachmentFields);
    }

    private MetadataType filterAttachmentsFromBodyType(MetadataType bodyType, List<ObjectFieldType> attachments) {
        if (!attachments.isEmpty() && bodyType instanceof ObjectType) {
            ObjectType operationType = SoapServiceMetadataTypeUtils.getOperationType(bodyType);
            attachments.forEach(a -> operationType.getFields().removeIf(f -> MetadataTypeUtils.getLocalPart(f).equals(MetadataTypeUtils.getLocalPart(a))));
            if (operationType.getFields().isEmpty()) {
                return this.nullType;
            }
        }
        return bodyType;
    }
}

