/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.service.soap.introspection.OperationDefinition;
import org.mule.service.soap.introspection.ServiceDefinition;

abstract class NodeMetadataResolver {
    final BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.XML);
    final MetadataType nullType = this.typeBuilder.nullType().build();
    final ServiceDefinition definition;
    final TypeLoader loader;
    final Function<OperationDefinition, Optional<Part>> bodyPartRetriever;

    NodeMetadataResolver(ServiceDefinition definition, TypeLoader loader, Function<OperationDefinition, Optional<Part>> bodyPartRetriever) {
        this.definition = definition;
        this.loader = loader;
        this.bodyPartRetriever = bodyPartRetriever;
    }

    abstract MetadataType getMetadata(String var1) throws MetadataResolvingException;

    MetadataType buildPartMetadataType(Part part) throws MetadataResolvingException {
        if (part.getElementName() != null) {
            String partName = part.getElementName().toString();
            return this.loader.load(partName).orElseThrow(() -> new MetadataResolvingException(String.format("Could not load part element name [%s]", partName), FailureCode.UNKNOWN));
        }
        throw new MetadataResolvingException("Trying to resolve metadata for a nameless part, probably the provided WSDL is invalid", FailureCode.INVALID_CONFIGURATION);
    }

    Part getBodyPart(OperationDefinition operation) throws MetadataResolvingException {
        return this.bodyPartRetriever.apply(operation).orElseThrow(() -> {
            String errorMsg = "No body type found for operation [" + operation.getName() + "]";
            return new MetadataResolvingException(errorMsg, FailureCode.INVALID_METADATA_KEY);
        });
    }

    boolean isOneWay(String operationName) {
        return OperationType.ONE_WAY.equals(this.definition.getOperation(operationName).getType());
    }
}

