/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import java.io.File;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.mule.tools.api.packager.structure.FolderNames;

public class MuleArchiver
extends ZipArchiver {
    public static final String ROOT_LOCATION = "";
    public static final String META_INF_LOCATION = FolderNames.META_INF.value() + File.separator;
    public static final String MAVEN_LOCATION = META_INF_LOCATION + FolderNames.MAVEN.value() + File.separator;
    public static final String MULE_SRC_LOCATION = META_INF_LOCATION + FolderNames.MULE_SRC.value() + File.separator;
    public static final String MULE_ARTIFACT_LOCATION = META_INF_LOCATION + FolderNames.MULE_ARTIFACT.value() + File.separator;
    public static final String REPOSITORY_LOCATION = FolderNames.REPOSITORY.value() + File.separator;

    public void addMuleSrc(File resource, String[] includes, String[] excludes) throws ArchiverException {
        if (resource.isFile()) {
            this.addFile(resource, MULE_SRC_LOCATION + resource.getName());
        } else {
            this.addDirectory(resource, MULE_SRC_LOCATION, includes, this.addDefaultExcludes(excludes));
        }
    }

    public void addMaven(File resource, String[] includes, String[] excludes) throws ArchiverException {
        if (resource.isFile()) {
            this.addFile(resource, MAVEN_LOCATION + resource.getName());
        } else {
            this.addDirectory(resource, MAVEN_LOCATION, includes, this.addDefaultExcludes(excludes));
        }
    }

    public void addMuleArtifact(File resource, String[] includes, String[] excludes) throws ArchiverException {
        if (resource.isFile()) {
            this.addFile(resource, MULE_ARTIFACT_LOCATION + resource.getName());
        } else {
            this.addDirectory(resource, MULE_ARTIFACT_LOCATION, includes, this.addDefaultExcludes(excludes));
        }
    }

    public void addRepository(File resource, String[] includes, String[] excludes) throws ArchiverException {
        if (resource.isFile()) {
            this.addFile(resource, REPOSITORY_LOCATION + resource.getName());
        } else {
            this.addDirectory(resource, REPOSITORY_LOCATION, includes, this.addDefaultExcludes(excludes));
        }
    }

    public void addToRoot(File resource, String[] includes, String[] excludes) throws ArchiverException {
        if (resource.isFile()) {
            this.addFile(resource, ROOT_LOCATION + resource.getName());
        } else {
            this.addDirectory(resource, ROOT_LOCATION, includes, this.addDefaultExcludes(excludes));
        }
    }

    private String[] addDefaultExcludes(String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return DirectoryScanner.DEFAULTEXCLUDES;
        }
        String[] newExcludes = new String[excludes.length + DirectoryScanner.DEFAULTEXCLUDES.length];
        System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, newExcludes, 0, DirectoryScanner.DEFAULTEXCLUDES.length);
        System.arraycopy(excludes, 0, newExcludes, DirectoryScanner.DEFAULTEXCLUDES.length, excludes.length);
        return newExcludes;
    }
}

