/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.interpreted.module;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.exception.InvalidNestingException;
import org.mule.weave.v2.grammar.Identifiers$;
import org.mule.weave.v2.interpreted.module.WeaveWriter$;
import org.mule.weave.v2.interpreted.module.WeaveWriter$Scope$;
import org.mule.weave.v2.interpreted.module.WeaveWriterSettings;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.SchemaProperty;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.FunctionType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.helper.AttributeHelper$;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.Stack;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001B\u0001\u0003\u0001=\u00111bV3bm\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007[>$W\u000f\\3\u000b\u0005\u00151\u0011aC5oi\u0016\u0014\bO]3uK\u0012T!a\u0002\u0005\u0002\u0005Y\u0014$BA\u0005\u000b\u0003\u00159X-\u0019<f\u0015\tYA\"\u0001\u0003nk2,'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/mi\u0011\u0001\u0007\u0006\u00033i\taa\u001e:ji\u0016\u0014(BA\u0002\u0007\u0013\ta\u0002D\u0001\u0004Xe&$XM\u001d\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005\u0011qn\u001d\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\n!![8\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)b\u0003CA\u0016\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010(\u0001\u0004y\u0002bB\r\u0001\u0005\u0004%IAL\u000b\u0002_A\u0011\u0001\u0005M\u0005\u0003c\u0005\u00121\u0002\u0015:j]R<&/\u001b;fe\"11\u0007\u0001Q\u0001\n=\nqa\u001e:ji\u0016\u0014\b\u0005C\u00046\u0001\t\u0007I\u0011\u0001\u001c\u0002\u0011M,G\u000f^5oON,\u0012a\u000e\t\u0003WaJ!!\u000f\u0002\u0003']+\u0017M^3Xe&$XM]*fiRLgnZ:\t\rm\u0002\u0001\u0015!\u00038\u0003%\u0019X\r\u001e;j]\u001e\u001c\beB\u0003>\u0001!\u0005a(A\u0003TG>\u0004X\r\u0005\u0002@\u00016\t\u0001AB\u0003B\u0001!\u0005!IA\u0003TG>\u0004Xm\u0005\u0002A\u0007B\u0011\u0011\u0003R\u0005\u0003\u000bJ\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\")\u0001\u0006\u0011C\u0001\u000fR\ta(\u0002\u0003B\u0001\u0002I\u0005C\u0001&L\u001b\u0005\u0001\u0015B\u0001'E\u0005\u00151\u0016\r\\;f\u0011\u001dq\u0005I1A\u0005\u0002=\u000b!\"R7qif\f%O]1z+\u0005I\u0005BB)AA\u0003%\u0011*A\u0006F[B$\u00180\u0011:sCf\u0004\u0003bB*A\u0005\u0004%\taT\u0001\u000e\u001d>tW)\u001c9us\u0006\u0013(/Y=\t\rU\u0003\u0005\u0015!\u0003J\u00039quN\\#naRL\u0018I\u001d:bs\u0002Bqa\u0016!C\u0002\u0013\u0005q*A\u0006F[B$\u0018\u0010S3bI\u0016\u0014\bBB-AA\u0003%\u0011*\u0001\u0007F[B$\u0018\u0010S3bI\u0016\u0014\b\u0005C\u0004\\\u0001\n\u0007I\u0011A(\u0002\u001d9{g.R7qifDU-\u00193fe\"1Q\f\u0011Q\u0001\n%\u000bqBT8o\u000b6\u0004H/\u001f%fC\u0012,'\u000f\t\u0005\b?\u0002\u0013\r\u0011\"\u0001P\u0003-)U\u000e\u001d;z\u001f\nTWm\u0019;\t\r\u0005\u0004\u0005\u0015!\u0003J\u00031)U\u000e\u001d;z\u001f\nTWm\u0019;!\u0011\u001d\u0019\u0007I1A\u0005\u0002=\u000bA\u0002R1oO2Lgn\u001a(b[\u0016Da!\u001a!!\u0002\u0013I\u0015!\u0004#b]\u001ed\u0017N\\4OC6,\u0007\u0005C\u0004h\u0001\n\u0007I\u0011A(\u0002\u001f\u0015k\u0007\u000f^=BiR\u0014\u0018NY;uKNDa!\u001b!!\u0002\u0013I\u0015\u0001E#naRL\u0018\t\u001e;sS\n,H/Z:!\u0011\u001dY\u0007I1A\u0005\u0002=\u000b!CT8o\u000b6\u0004H/_!uiJL'-\u001e;fg\"1Q\u000e\u0011Q\u0001\n%\u000b1CT8o\u000b6\u0004H/_!uiJL'-\u001e;fg\u0002Bqa\u001c!C\u0002\u0013\u0005q*\u0001\bO_:,U\u000e\u001d;z\u001f\nTWm\u0019;\t\rE\u0004\u0005\u0015!\u0003J\u0003=quN\\#naRLxJ\u00196fGR\u0004\u0003bB:A\u0005\u0004%\taT\u0001\u000e\u000b6\u0004H/\u001f#pGVlWM\u001c;\t\rU\u0004\u0005\u0015!\u0003J\u00039)U\u000e\u001d;z\t>\u001cW/\\3oi\u0002Bqa\u001e!C\u0002\u0013\u0005q*\u0001\tO_:,U\u000e\u001d;z\t>\u001cW/\\3oi\"1\u0011\u0010\u0011Q\u0001\n%\u000b\u0011CT8o\u000b6\u0004H/\u001f#pGVlWM\u001c;!\u0011\u001dY\bI1A\u0005\u0002=\u000baa\u00117pg\u0016$\u0007BB?AA\u0003%\u0011*A\u0004DY>\u001cX\r\u001a\u0011\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t!A\u0006eK\u001a,'O]3e\u0017\u0016LXCAA\u0002!\u0011\t)!a\u0005\u000f\t\u0005\u001d\u0011q\u0002\t\u0004\u0003\u0013\u0011RBAA\u0006\u0015\r\tiAD\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E!#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t9B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#\u0011\u0002bCA\u000e\u0001\u0001\u0007\t\u0019!C\u0005\u0003;\tq\u0002Z3gKJ\u0014X\rZ&fs~#S-\u001d\u000b\u0005\u0003?\t)\u0003E\u0002\u0012\u0003CI1!a\t\u0013\u0005\u0011)f.\u001b;\t\u0015\u0005\u001d\u0012\u0011DA\u0001\u0002\u0004\t\u0019!A\u0002yIEB\u0001\"a\u000b\u0001A\u0003&\u00111A\u0001\rI\u00164WM\u001d:fI.+\u0017\u0010\t\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t$A\neK\u001a,'O]3e\u0017\u0016LHj\\2bi&|g.\u0006\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012\u0001\u00037pG\u0006$\u0018n\u001c8\u000b\u0007\u0005ub!\u0001\u0004qCJ\u001cXM]\u0005\u0005\u0003\u0003\n9DA\bM_\u000e\fG/[8o\u0007\u0006\u0004\u0018M\u00197f\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\u0002/\u0011,g-\u001a:sK\u0012\\U-\u001f'pG\u0006$\u0018n\u001c8`I\u0015\fH\u0003BA\u0010\u0003\u0013B!\"a\n\u0002D\u0005\u0005\t\u0019AA\u001a\u0011!\ti\u0005\u0001Q!\n\u0005M\u0012\u0001\u00063fM\u0016\u0014(/\u001a3LKfdunY1uS>t\u0007\u0005C\u0006\u0002R\u0001\u0001\r\u00111A\u0005\n\u0005M\u0013!\u00053fM\u0016\u0014(/\u001a3OC6,7\u000f]1dKV\u0011\u0011Q\u000b\t\u0006#\u0005]\u00131L\u0005\u0004\u00033\u0012\"AB(qi&|g\u000e\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0013M$(/^2ukJ,'bAA3\r\u0005)Qn\u001c3fY&!\u0011\u0011NA0\u0005%q\u0015-\\3ta\u0006\u001cW\rC\u0006\u0002n\u0001\u0001\r\u00111A\u0005\n\u0005=\u0014!\u00063fM\u0016\u0014(/\u001a3OC6,7\u000f]1dK~#S-\u001d\u000b\u0005\u0003?\t\t\b\u0003\u0006\u0002(\u0005-\u0014\u0011!a\u0001\u0003+B\u0001\"!\u001e\u0001A\u0003&\u0011QK\u0001\u0013I\u00164WM\u001d:fI:\u000bW.Z:qC\u000e,\u0007\u0005C\u0006\u0002z\u0001\u0001\r\u00111A\u0005\n\u0005m\u0014A\u00053fM\u0016\u0014(/\u001a3BiR\u0014\u0018NY;uKN,\"!! \u0011\u000bE\t9&a \u0011\r\u0005\u0005\u0015qQAE\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\r\u0014A\u0002<bYV,7/C\u0002M\u0003\u0007\u0003B!!\u0018\u0002\f&!\u0011QRA0\u0005\u001dq\u0015-\\3TKFD1\"!%\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0014\u00061B-\u001a4feJ,G-\u0011;ue&\u0014W\u000f^3t?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005U\u0005BCA\u0014\u0003\u001f\u000b\t\u00111\u0001\u0002~!A\u0011\u0011\u0014\u0001!B\u0013\ti(A\neK\u001a,'O]3e\u0003R$(/\u001b2vi\u0016\u001c\b\u0005C\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0003\u0002 \u0006)1\u000f^1dWV\u0011\u0011\u0011\u0015\t\u0007\u0003G\u000bi+!-\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bq!\\;uC\ndWMC\u0002\u0002,J\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty+!*\u0003\u000bM#\u0018mY6\u0011\u0007\u0005M\u0006J\u0004\u0002@y!A\u0011q\u0017\u0001!\u0002\u0013\t\t+\u0001\u0004ti\u0006\u001c7\u000e\t\u0005\b\u0003w\u0003A\u0011IA_\u0003\u0015\u0019Gn\\:f)\t\ty\u0002C\u0004\u0002B\u0002!\t%a1\u0002\u001bM$\u0018M\u001d;E_\u000e,X.\u001a8u)\u0011\ty\"!2\t\u0011\u0005e\u0012q\u0018a\u0001\u0003gAq!!3\u0001\t\u0013\tY-A\u0007f]\u0012\fE\u000f\u001e:jEV$Xm\u001d\u000b\u0005\u0003?\ti\r\u0003\u0005\u0002:\u0005\u001d\u0007\u0019AA\u001a\u0011\u001d\t\t\u000e\u0001C!\u0003'\fq\u0002Z3gS:,g*Y7fgB\f7-\u001a\u000b\t\u0003?\t).a6\u0002\\\"A\u0011\u0011HAh\u0001\u0004\t\u0019\u0004\u0003\u0005\u0002Z\u0006=\u0007\u0019AA\u0002\u0003\u0019\u0001(/\u001a4jq\"A\u0011Q\\Ah\u0001\u0004\t\u0019!A\u0002ve&Dq!!9\u0001\t\u0003\ti,A\nxe&$X\rR3gKJ\u0014X\r\u001a%fC\u0012,'\u000fC\u0004\u0002f\u0002!I!a:\u0002\u001fM$\u0018M\u001d;BiR\u0014\u0018NY;uKN$B!a\b\u0002j\"A\u0011\u0011HAr\u0001\u0004\t\u0019\u0004C\u0004\u0002n\u0002!I!a<\u0002\u0017M$\u0018M\u001d;PE*,7\r\u001e\u000b\u0005\u0003c\fy\u0010\u0006\u0003\u0002 \u0005M\b\u0002CA{\u0003W\u0004\u001d!a>\u0002\u0007\r$\b\u0010\u0005\u0003\u0002z\u0006mXBAA2\u0013\u0011\ti0a\u0019\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000f\u0003\u0005\u0002:\u0005-\b\u0019AA\u001a\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000b\t\u0011\"\u001a8e\u001f\nTWm\u0019;\u0015\t\u0005}!q\u0001\u0005\t\u0003s\u0011\t\u00011\u0001\u00024!9!1\u0002\u0001\u0005\n\t5\u0011\u0001C3oI\u0006\u0013(/Y=\u0015\t\u0005}!q\u0002\u0005\t\u0003s\u0011I\u00011\u0001\u00024!9!1\u0003\u0001\u0005\n\tU\u0011AC:uCJ$\u0018I\u001d:bsR!!q\u0003B\u000e)\u0011\tyB!\u0007\t\u0011\u0005U(\u0011\u0003a\u0002\u0003oD\u0001\"!\u000f\u0003\u0012\u0001\u0007\u00111\u0007\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0003\u0011y\u0007/\u001a8\u0015\u0011\u0005}!1\u0005B\u0013\u0005SA\u0001\"!\u000f\u0003\u001e\u0001\u0007\u00111\u0007\u0005\t\u0005O\u0011i\u00021\u0001\u00022\u0006)1oY8qK\"A!1\u0006B\u000f\u0001\u0004\t\u0019!\u0001\u0004pa\u0016t7\t\u001b\u0005\b\u0003w\u0003A\u0011\u0002B\u0018))\tyB!\r\u00034\t]\"\u0011\b\u0005\t\u0003s\u0011i\u00031\u0001\u00024!A!Q\u0007B\u0017\u0001\u0004\t\t,A\u0003f[B$\u0018\u0010\u0003\u0005\u0002<\n5\u0002\u0019AAY\u0011!\u0011YD!\fA\u0002\u0005\r\u0011aB2m_N,7\t\u001b\u0005\b\u0005\u007f\u0001A\u0011\u0001B!\u00039\u0011X-];je\u0016\u001c\u0018+^8uKN$BAa\u0011\u0003JA\u0019\u0011C!\u0012\n\u0007\t\u001d#CA\u0004C_>dW-\u00198\t\u0011\t-#Q\ba\u0001\u0003\u0007\t1a[3z\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\n\u0001c\u001e:ji\u0016$UMZ3se\u0016$7*Z=\u0015\u0005\tMC\u0003BA\u0010\u0005+B\u0001\"!>\u0003N\u0001\u000f\u0011q\u001f\u0005\b\u00053\u0002A\u0011BA_\u0003\u001dqWm\u001e7j]\u0016DqA!\u0018\u0001\t\u0013\u0011y&A\u0005cK\u001a|'/Z&fsR!\u0011q\u0004B1\u0011!\tIDa\u0017A\u0002\u0005M\u0002b\u0002B3\u0001\u0011%!qM\u0001\fE\u00164wN]3WC2,X\r\u0006\u0003\u0002 \t%\u0004\u0002CA\u001d\u0005G\u0002\r!a\r\t\u000f\t-\u0003\u0001\"\u0003\u0003nQA\u0011q\u0004B8\u0005c\u0012Y\b\u0003\u0005\u0002:\t-\u0004\u0019AA\u001a\u0011!\u0011\u0019Ha\u001bA\u0002\tU\u0014!B9oC6,\u0007\u0003BA/\u0005oJAA!\u001f\u0002`\ti\u0011+^1mS\u001aLW\r\u001a(b[\u0016D\u0001B! \u0003l\u0001\u0007\u0011QP\u0001\u000bCR$(/\u001b2vi\u0016\u001c\bb\u0002BA\u0001\u0011\u0005#1Q\u0001\fK:$Gi\\2v[\u0016tG\u000f\u0006\u0003\u0002 \t\u0015\u0005\u0002CA\u001d\u0005\u007f\u0002\r!a\r\t\u000f\t%\u0005\u0001\"\u0011\u0003\f\u00061!/Z:vYR,\u0012a\b\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0003-9(/\u001b;f'\u000eDW-\\1\u0015\r\tM%q\u0013BT)\u0011\tyB!&\t\u0011\u0005U(Q\u0012a\u0002\u0003oD\u0001B!'\u0003\u000e\u0002\u0007!1T\u0001\u0002iB!!Q\u0014BR\u001b\t\u0011yJ\u0003\u0003\u0003\"\u0006\r\u0014!\u0002;za\u0016\u001c\u0018\u0002\u0002BS\u0005?\u0013A\u0001V=qK\"A!\u0011\u0016BG\u0001\u0004\u0011Y+\u0001\u0004tG\",W.\u0019\t\u0006#\u0005]#Q\u0016\t\u0005\u0005_\u0013\u0019,\u0004\u0002\u00032*!!\u0011VA0\u0013\u0011\u0011)L!-\u0003\rM\u001b\u0007.Z7b\u0011\u001d\u0011I\f\u0001C!\u0005w\u000b!b\u001e:ji\u00164\u0016\r\\;f)\u0011\u0011iL!1\u0015\t\u0005}!q\u0018\u0005\t\u0003k\u00149\fq\u0001\u0002x\"A!1\u0019B\\\u0001\u0004\u0011)-A\u0001wa\u0011\u00119M!4\u0011\r\u0005\u0005\u0015q\u0011Be!\u0011\u0011YM!4\r\u0001\u0011a!q\u001aBa\u0003\u0003\u0005\tQ!\u0001\u0003R\n\u0019q\fJ\u0019\u0012\t\tM'\u0011\u001c\t\u0004#\tU\u0017b\u0001Bl%\t9aj\u001c;iS:<\u0007cA\t\u0003\\&\u0019!Q\u001c\n\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003b\u0002!IAa9\u0002!]\u0014\u0018\u000e^3Rk>$Xm\u0015;sS:<G\u0003BA\u0010\u0005KD\u0001Ba:\u0003`\u0002\u0007\u00111A\u0001\tgR\u0014h+\u00197vK\"9!1\u001e\u0001\u0005B\u0005u\u0016!\u00024mkNDwa\u0002Bx\u0005!\u0005!\u0011_\u0001\f/\u0016\fg/Z,sSR,'\u000fE\u0002,\u0005g4a!\u0001\u0002\t\u0002\tU8c\u0001Bz!!9\u0001Fa=\u0005\u0002\teHC\u0001By\u0011!\u0011iPa=\u0005\u0002\t}\u0018!B1qa2LHc\u0001\f\u0004\u0002!1aDa?A\u0002}\u0001")
public class WeaveWriter
implements org.mule.weave.v2.module.writer.Writer {
    private volatile WeaveWriter$Scope$ Scope$module;
    private final OutputStream os;
    private final PrintWriter writer;
    private final WeaveWriterSettings settings;
    private String deferredKey;
    private LocationCapable deferredKeyLocation;
    private Option<Namespace> deferredNamespace;
    private Option<Value<NameSeq>> deferredAttributes;
    private final Stack<Enumeration.Value> stack;

    public static org.mule.weave.v2.module.writer.Writer apply(OutputStream outputStream) {
        return WeaveWriter$.MODULE$.apply(outputStream);
    }

    @Override
    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$(this, location, optionName, value);
    }

    public WeaveWriter$Scope$ Scope() {
        if (this.Scope$module == null) {
            this.Scope$lzycompute$1();
        }
        return this.Scope$module;
    }

    private PrintWriter writer() {
        return this.writer;
    }

    @Override
    public WeaveWriterSettings settings() {
        return this.settings;
    }

    private String deferredKey() {
        return this.deferredKey;
    }

    private void deferredKey_$eq(String x$1) {
        this.deferredKey = x$1;
    }

    private LocationCapable deferredKeyLocation() {
        return this.deferredKeyLocation;
    }

    private void deferredKeyLocation_$eq(LocationCapable x$1) {
        this.deferredKeyLocation = x$1;
    }

    private Option<Namespace> deferredNamespace() {
        return this.deferredNamespace;
    }

    private void deferredNamespace_$eq(Option<Namespace> x$1) {
        this.deferredNamespace = x$1;
    }

    private Option<Value<NameSeq>> deferredAttributes() {
        return this.deferredAttributes;
    }

    private void deferredAttributes_$eq(Option<Value<NameSeq>> x$1) {
        this.deferredAttributes = x$1;
    }

    private Stack<Enumeration.Value> stack() {
        return this.stack;
    }

    @Override
    public void close() {
        this.writer().close();
    }

    @Override
    public void startDocument(LocationCapable location) {
        this.stack().update(0, (Object)this.Scope().EmptyHeader());
    }

    private void endAttributes(LocationCapable location) {
        this.close(location, this.Scope().EmptyAttributes(), this.Scope().NonEmptyObject(), ")");
    }

    @Override
    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        this.writeDeferredHeader();
        this.writer().write("ns ");
        this.writer().write(prefix);
        this.writer().write(" ");
        this.writer().write(uri);
        this.newline();
        this.stack().update(0, (Object)this.Scope().NonEmptyHeader());
    }

    public void writeDeferredHeader() {
        this.writer().write("%dw 2.0");
        this.newline();
    }

    private void startAttributes(LocationCapable location) {
        this.stack().push((Object)this.Scope().EmptyAttributes());
        this.writer().write(" @(");
    }

    private void startObject(LocationCapable location, EvaluationContext ctx) {
        this.writeDeferredKey(ctx);
        this.open(location, this.Scope().EmptyObject(), "{");
    }

    private void endObject(LocationCapable location) {
        this.close(location, this.Scope().EmptyObject(), this.Scope().NonEmptyObject(), "}");
    }

    private void endArray(LocationCapable location) {
        this.close(location, this.Scope().EmptyArray(), this.Scope().NonEmptyArray(), "]");
    }

    private void startArray(LocationCapable location, EvaluationContext ctx) {
        this.writeDeferredKey(ctx);
        this.open(location, this.Scope().EmptyArray(), "[");
    }

    private void open(LocationCapable location, Enumeration.Value scope, String openCh) {
        this.beforeValue(location);
        this.stack().push((Object)scope);
        this.writer().write(openCh);
        this.writer().flush();
    }

    private void close(LocationCapable location, Enumeration.Value empty, Enumeration.Value close, String closeCh) {
        Enumeration.Value context;
        Enumeration.Value value = context = (Enumeration.Value)this.stack().top();
        Enumeration.Value value2 = empty;
        if (value == null ? value2 != null : !value.equals(value2)) {
            Enumeration.Value value3 = context;
            Enumeration.Value value4 = close;
            if (value3 == null ? value4 != null : !value3.equals(value4)) {
                throw new InvalidNestingException(location.location());
            }
        }
        this.stack().pop();
        Enumeration.Value value5 = context;
        Enumeration.Value value6 = close;
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            this.newline();
        }
        this.writer().write(closeCh);
        this.writer().flush();
    }

    public boolean requiresQuotes(String key) {
        return !key.matches("[a-zA-Z][a-zA-Z0-9_]*") || Identifiers$.MODULE$.keywords().contains((Object)key);
    }

    private void writeDeferredKey(EvaluationContext ctx) {
        block8: {
            if (this.deferredKey() == null) break block8;
            this.beforeKey(this.deferredKeyLocation());
            Option<Namespace> option = this.deferredNamespace();
            if (option instanceof Some) {
                Some some = (Some)option;
                Namespace ns = (Namespace)some.value();
                this.writer().write(ns.prefix());
                this.writer().write("#");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            if (this.requiresQuotes(this.deferredKey())) {
                this.writer().write("\"" + this.deferredKey() + "\"");
            } else {
                this.writer().write(this.deferredKey());
            }
            Option<Value<NameSeq>> option2 = this.deferredAttributes();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Value attrs = (Value)some.value();
                this.startAttributes(this.deferredKeyLocation());
                ((NameSeq)attrs.evaluate(ctx)).toIterator().foreach((Function1 & Serializable & scala.Serializable)env -> {
                    WeaveWriter.$anonfun$writeDeferredKey$1(this, ctx, env);
                    return BoxedUnit.UNIT;
                });
                this.endAttributes(this.deferredKeyLocation());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.deferredKey_$eq(null);
            this.deferredKeyLocation_$eq(null);
            this.deferredNamespace_$eq((Option<Namespace>)None$.MODULE$);
        }
    }

    private void newline() {
        block0: {
            if (this.settings().indent().length() <= 0) break block0;
            this.writer().write("\n");
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.stack().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.writer().write(this.settings().indent()));
        }
    }

    private void beforeKey(LocationCapable location) {
        boolean noIndent = this.settings().indent().isEmpty();
        String comma = noIndent ? ", " : ",";
        Enumeration.Value value = (Enumeration.Value)this.stack().top();
        Enumeration.Value value2 = this.Scope().NonEmptyObject();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.writer().write(comma);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = this.Scope().NonEmptyAttributes();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                this.writer().write(comma);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = this.Scope().EmptyObject();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value8 = this.Scope().EmptyAttributes();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new InvalidNestingException(location.location());
                    }
                }
            }
        }
        this.newline();
        this.stack().update(0, (Object)this.Scope().DanglingName());
    }

    private void beforeValue(LocationCapable location) {
        Enumeration.Value value = (Enumeration.Value)this.stack().top();
        Enumeration.Value value2 = this.Scope().NonEmptyHeader();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.writer().write("---");
            this.newline();
            this.stack().update(0, (Object)this.Scope().NonEmptyDocument());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl;
            Enumeration.Value value4 = this.Scope().EmptyDocument();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = this.Scope().EmptyHeader();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
            if (bl) {
                this.stack().update(0, (Object)this.Scope().NonEmptyDocument());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value8 = this.Scope().EmptyArray();
                Enumeration.Value value9 = value;
                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                    this.stack().update(0, (Object)this.Scope().NonEmptyArray());
                    this.newline();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value10 = this.Scope().NonEmptyArray();
                    Enumeration.Value value11 = value;
                    if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                        this.writer().append(",");
                        this.newline();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Enumeration.Value value12 = this.Scope().DanglingName();
                        Enumeration.Value value13 = value;
                        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                            this.writer().append(this.settings().separator());
                            this.stack().update(0, (Object)this.Scope().NonEmptyObject());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new InvalidNestingException(location.location());
                        }
                    }
                }
            }
        }
    }

    private void key(LocationCapable location, QualifiedName qname, Option<Value<NameSeq>> attributes) {
        this.deferredKey_$eq(qname.name());
        this.deferredKeyLocation_$eq(location);
        this.deferredNamespace_$eq(qname.namespace());
        this.deferredAttributes_$eq(attributes);
    }

    @Override
    public void endDocument(LocationCapable location) {
        this.writer().flush();
    }

    @Override
    public OutputStream result() {
        return this.os;
    }

    public void writeSchema(Type t, Option<Schema> schema, EvaluationContext ctx) {
        Some some;
        Schema theSchema;
        Option<Schema> option = schema;
        if (option instanceof Some && (theSchema = (Schema)(some = (Some)option).value()).properties().nonEmpty()) {
            this.writer().write(" as ");
            this.writer().write(t.name());
            this.writer().write(" {");
            BooleanRef first = BooleanRef.create((boolean)true);
            theSchema.properties().foreach((Function1 & Serializable & scala.Serializable)sproperty -> {
                WeaveWriter.$anonfun$writeSchema$1(this, ctx, first, sproperty);
                return BoxedUnit.UNIT;
            });
            this.writer().write("}");
            this.writer().flush();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void writeValue(Value<?> v, EvaluationContext ctx) {
        Type type;
        Type type2;
        Type type3;
        Type type4;
        Type type5;
        Type type6;
        Type type7;
        Type type8;
        this.writeDeferredKey(ctx);
        Type type9 = v.valueType(ctx);
        if (type9 != null && (type8 = type9).isInstanceOf(BooleanType$.MODULE$, ctx)) {
            this.beforeValue(v);
            this.writer().write(v.evaluate(ctx).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type9 != null && (type7 = type9).isInstanceOf(NumberType$.MODULE$, ctx)) {
            this.beforeValue(v);
            this.writer().write((String)StringType$.MODULE$.coerce(v, ctx).evaluate(ctx));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type9 != null && (type6 = type9).isInstanceOf(NullType$.MODULE$, ctx)) {
            this.beforeValue(v);
            this.writer().write("null");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type9 != null && (type5 = type9).isInstanceOf(ArrayType$.MODULE$, ctx)) {
            this.startArray(v, ctx);
            ((ArraySeq)v.evaluate(ctx)).toIterator().foreach((Function1 & Serializable & scala.Serializable)v2 -> {
                this.writeValue(v2, ctx);
                return BoxedUnit.UNIT;
            });
            this.endArray(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type9 != null && (type4 = type9).isInstanceOf(RangeType$.MODULE$, ctx)) {
            this.writeValue(ArrayType$.MODULE$.coerce(v, ctx), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type9 != null && (type3 = type9).isInstanceOf(ArrayType$.MODULE$, ctx)) {
            this.startArray(v, ctx);
            ((ArraySeq)v.evaluate(ctx)).toIterator().foreach((Function1 & Serializable & scala.Serializable)v2 -> {
                this.writeValue(v2, ctx);
                return BoxedUnit.UNIT;
            });
            this.endArray(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type9 != null && (type2 = type9).isInstanceOf(ObjectType$.MODULE$, ctx)) {
            this.startObject(v, ctx);
            ((ObjectSeq)v.evaluate(ctx)).toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)ekv -> {
                WeaveWriter.$anonfun$writeValue$3(this, ctx, ekv);
                return BoxedUnit.UNIT;
            });
            this.endObject(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (type9 != null && (type = type9).isInstanceOf(FunctionType$.MODULE$, ctx)) {
            this.beforeValue(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.beforeValue(v);
            String strValue = (String)StringType$.MODULE$.coerce(v, ctx).evaluate(ctx);
            this.writeQuoteString(strValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.writeSchema(v.valueType(ctx), v.valueType(ctx).schema(ctx), ctx);
    }

    private void writeQuoteString(String strValue) {
        int len = strValue.length();
        this.writer().write("\"");
        block9: for (int i = 0; i < len; ++i) {
            char c = strValue.charAt(i);
            switch (c) {
                case '\"': {
                    this.writer().write("\\\"");
                    continue block9;
                }
                case '\\': {
                    if (len >= i + 6 && strValue.substring(i + 1, i + 6).matches("u[0-9a-fA-F]{4}")) {
                        this.writer().write("\\");
                        continue block9;
                    }
                    this.writer().write("\\\\");
                    continue block9;
                }
                case '\b': {
                    this.writer().write("\\b");
                    continue block9;
                }
                case '\f': {
                    this.writer().write("\\f");
                    continue block9;
                }
                case '\n': {
                    this.writer().write("\\n");
                    continue block9;
                }
                case '\r': {
                    this.writer().write("\\r");
                    continue block9;
                }
                case '\t': {
                    this.writer().write("\\t");
                    continue block9;
                }
                default: {
                    this.writer().write(c);
                    continue block9;
                }
            }
        }
        this.writer().write("\"");
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    private final void Scope$lzycompute$1() {
        WeaveWriter weaveWriter = this;
        synchronized (weaveWriter) {
            if (this.Scope$module == null) {
                this.Scope$module = new WeaveWriter$Scope$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$writeDeferredKey$1(WeaveWriter $this, EvaluationContext ctx$1, NameValuePair env) {
        block0: {
            if (env._2().valueType(ctx$1).isInstanceOf(NullType$.MODULE$, ctx$1)) break block0;
            $this.key((LocationCapable)env._1(), (QualifiedName)env._1().evaluate(ctx$1), (Option<Value<NameSeq>>)None$.MODULE$);
            $this.writeValue((Value<?>)env._2(), ctx$1);
        }
    }

    public static final /* synthetic */ void $anonfun$writeSchema$1(WeaveWriter $this, EvaluationContext ctx$3, BooleanRef first$1, SchemaProperty sproperty) {
        Object object = !first$1.elem ? $this.writer().append(", ") : BoxedUnit.UNIT;
        $this.writer().append(sproperty.name().evaluate(ctx$3));
        $this.writer().write(": \"");
        $this.writer().write(sproperty.value().evaluate(ctx$3).toString());
        $this.writer().write("\"");
        first$1.elem = false;
    }

    public static final /* synthetic */ void $anonfun$writeValue$3(WeaveWriter $this, EvaluationContext ctx$2, KeyValuePair ekv) {
        $this.key((LocationCapable)ekv._1(), (QualifiedName)ekv._1().evaluate(ctx$2), AttributeHelper$.MODULE$.attributes((Value<?>)ekv._1(), ctx$2));
        $this.writeValue((Value<?>)ekv._2(), ctx$2);
    }

    public WeaveWriter(OutputStream os) {
        this.os = os;
        ConfigurableReaderWriter.$init$(this);
        org.mule.weave.v2.module.writer.Writer.$init$(this);
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), true);
        this.settings = new WeaveWriterSettings();
        this.stack = new Stack();
        this.stack().push((Object)this.Scope().EmptyDocument());
    }
}

