/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.weave.v2.module.reader.AutoPersistedOutputStream;
import org.mule.weave.v2.module.reader.Reader;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider$;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.ExecutableWeave;
import org.mule.weave.v2.runtime.ExecutableWeaveHelper$;
import org.mule.weave.v2.runtime.WeaveCompiler$;
import org.mule.weave.v2.runtime.WeaveInput;
import org.mule.weave.v2.runtime.utils.WeaveResult;
import org.mule.weave.v2.sdk.ParsingContextFactory$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.ts.WeaveType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001=\u0011\u0011cV3bm\u0016\u001c\u0016.\u001c9mKJ+hN\\3s\u0015\t\u0019A!A\u0003vi&d7O\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\t1(G\u0003\u0002\n\u0015\u0005)q/Z1wK*\u00111\u0002D\u0001\u0005[VdWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005q\u0001/\u0019:tS:<7i\u001c8uKb$X#A\r\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012!\u00029iCN,'B\u0001\u0010\u0007\u0003\u0019\u0001\u0018M]:fe&\u0011\u0001e\u0007\u0002\u000f!\u0006\u00148/\u001b8h\u0007>tG/\u001a=u\u0011!\u0011\u0003A!A!\u0002\u0013I\u0012a\u00049beNLgnZ\"p]R,\u0007\u0010\u001e\u0011\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\t1\u0003\u0006\u0005\u0002(\u00015\t!\u0001C\u0003\u0018G\u0001\u0007\u0011\u0004C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002\r%t\u0007/\u001e;t+\u0005a\u0003\u0003B\u00173i}j\u0011A\f\u0006\u0003_A\nq!\\;uC\ndWM\u0003\u00022%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Mr#aA'baB\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\n\u000e\u0003aR!!\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\tY$#\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u0013!\t\u0001\u0015)D\u0001\u0005\u0013\t\u0011EA\u0001\u0006XK\u00064X-\u00138qkRDa\u0001\u0012\u0001!\u0002\u0013a\u0013aB5oaV$8\u000f\t\u0005\b\r\u0002\u0001\r\u0011\"\u0003H\u0003=i\u0017-\u001f2f\u001fV$\b/\u001e;UsB,W#\u0001%\u0011\u0007EIE'\u0003\u0002K%\t1q\n\u001d;j_:Dq\u0001\u0014\u0001A\u0002\u0013%Q*A\nnCf\u0014WmT;uaV$H+\u001f9f?\u0012*\u0017\u000f\u0006\u0002O#B\u0011\u0011cT\u0005\u0003!J\u0011A!\u00168ji\"9!kSA\u0001\u0002\u0004A\u0015a\u0001=%c!1A\u000b\u0001Q!\n!\u000b\u0001#\\1zE\u0016|U\u000f\u001e9viRK\b/\u001a\u0011\t\u000b\u0011\u0002A\u0011\u0001,\u0015\u0003\u0019BQ\u0001\u0017\u0001\u0005\u0002e\u000b\u0001\"\u00193e\u0013:\u0004X\u000f\u001e\u000b\u0005\u001djcf\fC\u0003\\/\u0002\u0007A'\u0001\u0003oC6,\u0007\"B/X\u0001\u0004!\u0014aC2p]R,g\u000e\u001e+za\u0016DQaX,A\u0002\u0001\fqaY8oi\u0016tG\u000f\u0005\u0002bM6\t!M\u0003\u0002dI\u00061!/Z1eKJT!!\u001a\u0004\u0002\r5|G-\u001e7f\u0013\t9'M\u0001\bT_V\u00148-\u001a)s_ZLG-\u001a:\t\u000ba\u0003A\u0011A5\u0015\u00079S7\u000eC\u0003\\Q\u0002\u0007A\u0007C\u0003mQ\u0002\u0007Q.\u0001\u0003gS2,\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\tIwNC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q|'\u0001\u0002$jY\u0016DQA\u001e\u0001\u0005\u0002]\fQb]3u\u001fV$\b/\u001e;UsB,GC\u0001(y\u0011\u0015IX\u000f1\u00015\u0003)yW\u000f\u001e9viRK\b/\u001a\u0005\u0006w\u0002!\t\u0001`\u0001\bKb,7-\u001e;f)\ri\u0018\u0011\u0001\t\u0003OyL!a \u0002\u0003\u0017]+\u0017M^3SKN,H\u000e\u001e\u0005\u0007\u0003\u0007Q\b\u0019\u0001\u001b\u0002\rM\u001c'/\u001b9u\u0011\u0019Y\b\u0001\"\u0001\u0002\bQ\u0019Q0!\u0003\t\r1\f)\u00011\u0001n\u0011\u0019Y\b\u0001\"\u0005\u0002\u000eQ\u0019Q0a\u0004\t\u0011\u0005E\u00111\u0002a\u0001\u0003'\tQb^3bm\u0016\u0014Vm]8ve\u000e,\u0007\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005ea!A\u0002tI.LA!!\b\u0002\u0018\tiq+Z1wKJ+7o\\;sG\u0016Daa\u001f\u0001\u0005\u0012\u0005\u0005B#B?\u0002$\u0005\u0015\u0002\u0002CA\t\u0003?\u0001\r!a\u0005\t\re\fy\u00021\u00015\u0011\u001d\tI\u0003\u0001C\t\u0003W\t\u0011\u0002Z8Fq\u0016\u001cW\u000f^3\u0015\u000bu\fi#a\f\t\u0011\u0005E\u0011q\u0005a\u0001\u0003'A\u0001\"!\r\u0002(\u0001\u0007\u00111G\u0001\u000eoJLG/\u001a:De\u0016\fGo\u001c:\u0011\u000fE\t)$!\u000f\u0002X%\u0019\u0011q\u0007\n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0007BA\u001e\u0003\u000b\u0002R\u0001QA\u001f\u0003\u0003J1!a\u0010\u0005\u0005=)\u00050Z2vi\u0006\u0014G.Z,fCZ,\u0007\u0003BA\"\u0003\u000bb\u0001\u0001\u0002\u0007\u0002H\u0005=\u0012\u0011!A\u0001\u0006\u0003\tIEA\u0002`IE\nB!a\u0013\u0002RA\u0019\u0011#!\u0014\n\u0007\u0005=#CA\u0004O_RD\u0017N\\4\u0011\u0007E\t\u0019&C\u0002\u0002VI\u00111!\u00118z!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/I\u00061qO]5uKJLA!!\u0019\u0002\\\t1qK]5uKJDq!!\u001a\u0001\t\u0003\t9'\u0001\tj]\u001a,'oQ8oi\u0016tG\u000fV=qKR)A'!\u001b\u0002n!9\u00111NA2\u0001\u0004!\u0014!C5oaV$h*Y7f\u0011\u001d\ty'a\u0019A\u0002A\tQ!\u001b8qkR\u0004")
public class WeaveSimpleRunner {
    private final ParsingContext parsingContext;
    private final Map<String, WeaveInput> inputs;
    private Option<String> maybeOutputType;

    public ParsingContext parsingContext() {
        return this.parsingContext;
    }

    private Map<String, WeaveInput> inputs() {
        return this.inputs;
    }

    private Option<String> maybeOutputType() {
        return this.maybeOutputType;
    }

    private void maybeOutputType_$eq(Option<String> x$1) {
        this.maybeOutputType = x$1;
    }

    public void addInput(String name, String contentType, SourceProvider content) {
        this.inputs().put((Object)name, (Object)new WeaveInput(name, contentType, content));
    }

    public void addInput(String name, File file) {
        String contentType = this.inferContentType(name, file);
        this.inputs().put((Object)name, (Object)new WeaveInput(name, contentType, SourceProvider$.MODULE$.apply(file)));
    }

    public void setOutputType(String outputType) {
        this.maybeOutputType_$eq((Option<String>)new Some((Object)outputType));
    }

    public WeaveResult execute(String script) {
        return this.execute(WeaveResourceFactory$.MODULE$.fromContent(script));
    }

    public WeaveResult execute(File file) {
        return this.execute(WeaveResourceFactory$.MODULE$.fromFile(file));
    }

    public WeaveResult execute(WeaveResource weaveResource) {
        return this.maybeOutputType().isDefined() ? this.doExecute(weaveResource, (Function1 & Serializable & scala.Serializable)x -> ExecutableWeaveHelper$.MODULE$.buildWriter((String)this.maybeOutputType().get())) : this.doExecute(weaveResource, (Function1 & Serializable & scala.Serializable)x -> x.createImplicitWriter());
    }

    public WeaveResult execute(WeaveResource weaveResource, String outputType) {
        return this.doExecute(weaveResource, (Function1 & Serializable & scala.Serializable)x -> ExecutableWeaveHelper$.MODULE$.buildWriter(outputType));
    }

    public WeaveResult doExecute(WeaveResource weaveResource, Function1<ExecutableWeave<?>, Writer> writerCreator) {
        Object object;
        NameIdentifier anonymous = NameIdentifier$.MODULE$.anonymous();
        this.inputs().keys().foreach((Function1 & Serializable & scala.Serializable)inputName -> {
            WeaveSimpleRunner.$anonfun$doExecute$1(this, inputName);
            return BoxedUnit.UNIT;
        });
        PhaseResult<CompilationResult<DocumentNode>> phaseResult = WeaveCompiler$.MODULE$.compileWithNoCheck(weaveResource, this.parsingContext());
        ExecutableWeave<DocumentNode> executable = phaseResult.getResult().executable();
        scala.collection.immutable.Map<String, Reader> readers = ExecutableWeaveHelper$.MODULE$.buildReaders((scala.collection.immutable.Map<String, WeaveInput>)this.inputs().toMap(Predef$.MODULE$.$conforms()));
        Writer writer = (Writer)writerCreator.apply(executable);
        Tuple2<Object, Charset> tuple2 = executable.write(writer, readers, executable.write$default$3(), executable.write$default$4());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object result = tuple2._1();
        Charset charset = (Charset)tuple2._2();
        Tuple2 tuple22 = new Tuple2(result, (Object)charset);
        Tuple2 tuple23 = tuple22;
        Object result2 = tuple23._1();
        Charset charset2 = (Charset)tuple23._2();
        Object object2 = result2;
        if (object2 instanceof AutoPersistedOutputStream) {
            AutoPersistedOutputStream autoPersistedOutputStream = (AutoPersistedOutputStream)object2;
            object = autoPersistedOutputStream.getInputStream();
        } else if (object2 instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)object2;
            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        } else {
            object = result2;
        }
        Object resultObject = object;
        return new WeaveResult(resultObject, charset2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String inferContentType(String inputName, Object input) {
        Object object = input;
        if (!(object instanceof File)) throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't infer data format for ", ". Add an input directive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputName})));
        File file = (File)object;
        String extension = (String)new StringOps(Predef$.MODULE$.augmentString(file.getName())).drop(file.getName().lastIndexOf(46));
        String string = extension;
        if (".json".equals(string)) {
            return "application/json";
        }
        if (".xml".equals(string)) {
            return "application/xml";
        }
        if (".csv".equals(string)) {
            return "application/csv";
        }
        if (!".dwl".equals(string)) throw new IllegalArgumentException("Don't know how to parse " + extension);
        return "application/dw";
    }

    public static final /* synthetic */ void $anonfun$doExecute$1(WeaveSimpleRunner $this, String inputName) {
        $this.parsingContext().addImplicitInput(inputName, (Option<WeaveType>)None$.MODULE$);
    }

    public WeaveSimpleRunner(ParsingContext parsingContext) {
        this.parsingContext = parsingContext;
        this.inputs = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.maybeOutputType = None$.MODULE$;
    }

    public WeaveSimpleRunner() {
        this(ParsingContextFactory$.MODULE$.createMappingParsingContext(NameIdentifier$.MODULE$.anonymous()));
    }
}

