/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.ImmutableRemoteRepository;

public interface RemoteRepository {
    public String getId();

    public URL getUrl();

    public Optional<Authentication> getAuthentication();

    public static RemoteRepositoryBuilder newRemoteRepositoryBuilder() {
        return new RemoteRepositoryBuilder();
    }

    public static class RemoteRepositoryBuilder {
        private String id;
        private URL url;
        private Authentication authentication;

        public RemoteRepositoryBuilder id(String id) {
            Objects.requireNonNull(id, "id cannot be null");
            this.id = id;
            return this;
        }

        public RemoteRepositoryBuilder url(URL url) {
            Objects.requireNonNull(url, "remoteRepositoryUrl cannot be null");
            this.url = url;
            return this;
        }

        public RemoteRepositoryBuilder authentication(Authentication authentication) {
            Objects.requireNonNull(authentication, "authentication cannot be null");
            this.authentication = authentication;
            return this;
        }

        public RemoteRepository build() {
            return new ImmutableRemoteRepository(this.id, this.url, Optional.ofNullable(this.authentication));
        }
    }
}

