/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.el.ModuleDefinition;

public class TypeBindings {
    public static final String PAYLOAD_IDENTIFIER_NAME = "payload";
    public static final String ATTRIBUTES_IDENTIFIER_NAME = "attributes";
    public static final String VARIABLES_IDENTIFIER_NAME = "vars";
    public static final String MESSAGE_IDENTIFIER_NAME = "message";
    private Map<String, MetadataType> bindings;
    private Collection<ModuleDefinition> modules;

    private TypeBindings(Map<String, MetadataType> bindings, Collection<ModuleDefinition> modules) {
        this.bindings = bindings;
        this.modules = modules;
    }

    public Set<String> identifiers() {
        return this.bindings.keySet();
    }

    public Optional<MetadataType> lookup(String name) {
        return Optional.ofNullable(this.bindings.get(name));
    }

    public Collection<ModuleDefinition> modules() {
        return this.modules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MuleEventMetadataType muleEventMetadataType) {
        Builder builder = TypeBindings.builder();
        MessageMetadataType messageType = muleEventMetadataType.getMessageType();
        messageType.getPayloadType().ifPresent(metadataType -> builder.addBinding(PAYLOAD_IDENTIFIER_NAME, (MetadataType)metadataType));
        messageType.getAttributesType().ifPresent(metadataType -> builder.addBinding(ATTRIBUTES_IDENTIFIER_NAME, (MetadataType)metadataType));
        builder.addBinding(VARIABLES_IDENTIFIER_NAME, muleEventMetadataType.getVariables());
        builder.addBinding(MESSAGE_IDENTIFIER_NAME, muleEventMetadataType.getMessageType());
        return builder;
    }

    public Optional<ModuleDefinition> lookupModule(String moduleName) {
        return this.modules.stream().filter(module -> module.getName().toString().equals(moduleName)).findFirst();
    }

    public static class Builder {
        private Map<String, MetadataType> bindings = new HashMap<String, MetadataType>();
        private List<ModuleDefinition.Builder> modules = new ArrayList<ModuleDefinition.Builder>();
        private List<TypeBindings> parents = new ArrayList<TypeBindings>();

        public Builder addAll(TypeBindings bindings) {
            this.parents.add(bindings);
            return this;
        }

        public Builder addBinding(String identifier, MetadataType metadataType) {
            this.bindings.put(identifier, metadataType);
            return this;
        }

        public ModuleDefinition.Builder module(String name) {
            ModuleDefinition.Builder builder = ModuleDefinition.builder(name);
            this.modules.add(builder);
            return builder;
        }

        public TypeBindings build() {
            List resultModules = this.modules.stream().map(ModuleDefinition.Builder::build).collect(Collectors.toList());
            HashMap<String, MetadataType> resultBindings = new HashMap<String, MetadataType>(this.bindings);
            for (TypeBindings parent : this.parents) {
                resultBindings.putAll(parent.bindings);
                resultModules.addAll(parent.modules);
            }
            return new TypeBindings(resultBindings, resultModules);
        }
    }
}

