/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.config.internal.BeanDependencyResolver;
import org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationDependencyResolver
implements BeanDependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationDependencyResolver.class);
    private final ApplicationModel applicationModel;
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;

    public ConfigurationDependencyResolver(ApplicationModel applicationModel, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) {
        this.applicationModel = applicationModel;
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
    }

    private Set<String> resolveComponentModelDependencies(ComponentModel componentModel) {
        Set<String> otherRequiredGlobalComponents = this.resolveComponentDependencies(componentModel);
        return this.findComponentModelsDependencies(otherRequiredGlobalComponents);
    }

    protected Set<String> resolveComponentDependencies(ComponentModel requestedComponentModel) {
        HashSet<String> otherDependencies = new HashSet<String>();
        requestedComponentModel.getInnerComponents().stream().forEach(childComponent -> otherDependencies.addAll(this.resolveComponentDependencies((ComponentModel)childComponent)));
        final HashSet parametersReferencingDependencies = new HashSet();
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(requestedComponentModel.getIdentifier()).ifPresent(buildingDefinition -> buildingDefinition.getAttributesDefinitions().stream().forEach(attributeDefinition -> attributeDefinition.accept(new AbstractAttributeDefinitionVisitor(){

            @Override
            public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
                Arrays.stream(definitions).forEach(keyAttributeDefinitionPair -> keyAttributeDefinitionPair.getAttributeDefinition().accept(this));
            }

            @Override
            public void onReferenceSimpleParameter(String reference) {
                parametersReferencingDependencies.add(reference);
            }
        })));
        for (String parametersReferencingDependency : parametersReferencingDependencies) {
            if (!requestedComponentModel.getParameters().containsKey(parametersReferencingDependency)) continue;
            this.appendDependency(otherDependencies, requestedComponentModel, parametersReferencingDependency);
        }
        if (this.isCoreComponent(requestedComponentModel.getIdentifier(), "flow-ref")) {
            this.appendDependency(otherDependencies, requestedComponentModel, "name");
        } else if (this.isCoreComponent(requestedComponentModel.getIdentifier(), "configuration")) {
            this.appendDependency(otherDependencies, requestedComponentModel, "defaultErrorHandler-ref");
        }
        return otherDependencies;
    }

    protected Set<String> findComponentModelsDependencies(Set<String> componentModelNames) {
        HashSet<String> componentsToSearchDependencies = new HashSet<String>(componentModelNames);
        LinkedHashSet<String> foundDependencies = new LinkedHashSet<String>();
        HashSet<String> alreadySearchedDependencies = new HashSet<String>();
        do {
            componentsToSearchDependencies.addAll(foundDependencies);
            for (String componentModelName : componentsToSearchDependencies) {
                if (alreadySearchedDependencies.contains(componentModelName)) continue;
                alreadySearchedDependencies.add(componentModelName);
                foundDependencies.addAll(this.resolveComponentDependencies(this.findRequiredComponentModel(componentModelName)));
            }
            foundDependencies.addAll(componentModelNames);
        } while (!foundDependencies.containsAll(componentsToSearchDependencies));
        return foundDependencies;
    }

    private void appendDependency(Set<String> otherDependencies, ComponentModel requestedComponentModel, String parametersReferencingDependency) {
        String name = requestedComponentModel.getParameters().get(parametersReferencingDependency);
        if (this.applicationModel.findTopLevelNamedElement(name).isPresent()) {
            otherDependencies.add(name);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Ignoring dependency %s because it does not exists", name));
        }
    }

    private boolean isCoreComponent(ComponentIdentifier componentIdentifier, String name) {
        return componentIdentifier.getNamespace().equals("mule") && componentIdentifier.getName().equals(name);
    }

    private ComponentModel findRequiredComponentModel(String name) {
        return this.applicationModel.findTopLevelNamedComponent(name).orElseThrow(() -> new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage("No named component with name " + name)));
    }

    protected ComponentModel findRequiredComponentModel(Location location) {
        Reference foundComponentModelReference = new Reference();
        Optional<ComponentModel> globalComponent = this.applicationModel.findTopLevelNamedComponent(location.getGlobalName());
        globalComponent.ifPresent(componentModel -> this.findComponentWithLocation((ComponentModel)componentModel, location).ifPresent(foundComponentModel -> foundComponentModelReference.set(foundComponentModel)));
        if (foundComponentModelReference.get() == null) {
            throw new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage("No object found at location " + location.toString()));
        }
        return (ComponentModel)foundComponentModelReference.get();
    }

    private Optional<ComponentModel> findComponentWithLocation(ComponentModel componentModel, Location location) {
        if (componentModel.getComponentLocation().getLocation().equals(location.toString())) {
            return Optional.of(componentModel);
        }
        for (ComponentModel childComponent : componentModel.getInnerComponents()) {
            Optional<ComponentModel> foundComponent = this.findComponentWithLocation(childComponent, location);
            if (!foundComponent.isPresent()) continue;
            return foundComponent;
        }
        return Optional.empty();
    }

    public Collection<String> resolveComponentDependencies(String componentName) {
        try {
            ComponentModel requiredComponentModel = this.findRequiredComponentModel(componentName);
            return this.resolveComponentModelDependencies(requiredComponentModel);
        }
        catch (NoSuchComponentModelException e) {
            return Collections.emptyList();
        }
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    @Override
    public Collection<Object> resolveBeanDependencies(Set<String> beanNames) {
        return null;
    }

    public List<ComponentModel> findRequiredComponentModels(LazyComponentInitializer.ComponentLocationFilter filter) {
        ArrayList<ComponentModel> components = new ArrayList<ComponentModel>();
        this.applicationModel.executeOnEveryComponentTree(componentModel -> {
            if (componentModel.getComponentLocation() != null && filter.accept(componentModel.getComponentLocation())) {
                components.add((ComponentModel)componentModel);
            }
        });
        return components;
    }

    public Set<String> resolveAlwaysEnabledComponents() {
        ImmutableSet.Builder namesBuilder = ImmutableSet.builder();
        this.applicationModel.executeOnEveryRootElement(componentModel -> {
            Optional<ComponentBuildingDefinition<?>> buildingDefinition = this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier());
            buildingDefinition.ifPresent(definition -> {
                if (definition.isAlwaysEnabled() && componentModel.getNameAttribute() != null) {
                    namesBuilder.add((Object)componentModel.getNameAttribute());
                }
            });
        });
        return namesBuilder.build();
    }
}

