/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.AnnotatedProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.routing.RoutePathNotFoundException;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FlowRefFactoryBean
extends AbstractComponentFactory<Processor>
implements ApplicationContextAware,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;

    public void setName(String name) {
        this.refName = name;
    }

    @Override
    public Processor doGetObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new IllegalArgumentException("flow-ref name is empty");
        }
        return new FlowRefMessageProcessor();
    }

    protected Processor getReferencedFlow(String name, FlowRefMessageProcessor flowRefMessageProcessor) throws MuleException {
        if (name == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("flow-ref name expression returned 'null'"), flowRefMessageProcessor);
        }
        Processor referencedFlow = this.getReferencedProcessor(name);
        if (referencedFlow == null) {
            throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("No flow/sub-flow with name '%s' found", name), flowRefMessageProcessor);
        }
        if (!(referencedFlow instanceof Flow)) {
            HashMap<QName, Object> annotations = new HashMap<QName, Object>(((Component)((Object)referencedFlow)).getAnnotations());
            annotations.put(ROOT_CONTAINER_NAME_KEY, this.getRootContainerLocation().toString());
            ((Component)((Object)referencedFlow)).setAnnotations(annotations);
            if (referencedFlow instanceof Initialisable) {
                LifecycleUtils.initialiseIfNeeded(referencedFlow, this.muleContext);
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (Processor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        LifecycleUtils.setMuleContextIfNeeded(processor, this.muleContext);
                    }
                }
            }
            LifecycleUtils.startIfNeeded(referencedFlow);
        }
        return referencedFlow;
    }

    private Processor getReferencedProcessor(String name) {
        if (this.applicationContext instanceof MuleArtifactContext) {
            MuleArtifactContext muleArtifactContext = (MuleArtifactContext)this.applicationContext;
            try {
                if (muleArtifactContext.getBeanFactory().getBeanDefinition(name).isPrototype()) {
                    muleArtifactContext.getPrototypeBeanWithRootContainer(name, this.getRootContainerLocation().toString());
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
        return (Processor)this.applicationContext.getBean(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private class FlowRefMessageProcessor
    extends AbstractComponent
    implements AnnotatedProcessor,
    Stoppable,
    Disposable {
        private LoadingCache<String, Processor> cache;
        private boolean isExpression;

        public FlowRefMessageProcessor() {
            this.cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key, FlowRefMessageProcessor.this);
                }
            });
            this.isExpression = FlowRefFactoryBean.this.muleContext.getExpressionManager().isExpression(FlowRefFactoryBean.this.refName);
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor referencedProcessor;
                try {
                    referencedProcessor = this.resolveReferencedProcessor((CoreEvent)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                if (referencedProcessor instanceof Flow) {
                    return Flux.just((Object)event).flatMap(request -> Mono.from(MessageProcessors.processWithChildContext(request, referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation()), ((Flow)referencedProcessor).getExceptionListener())));
                }
                return Flux.just((Object)event).transform((Function)referencedProcessor);
            });
        }

        protected Processor resolveReferencedProcessor(CoreEvent event) throws MuleException {
            String flowName = this.isExpression ? FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event, this.getLocation()) : FlowRefFactoryBean.this.refName;
            try {
                return (Processor)this.cache.getUnchecked((Object)flowName);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                if (e.getCause() instanceof MuleException) {
                    throw (MuleException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public ComponentLocation getLocation() {
            return FlowRefFactoryBean.this.getLocation();
        }

        @Override
        public void stop() throws MuleException {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded(p);
            }
        }

        @Override
        public void dispose() {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded(p, LOGGER);
            }
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

