/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PolicyChain
extends AbstractComponent
implements Initialisable,
Startable,
Stoppable,
Disposable,
Processor {
    @Inject
    private MuleContext muleContext;
    private List<Processor> processors;
    private MessageProcessorChain processorChain;
    private PolicyNotificationHelper notificationHelper;

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public final void initialise() throws InitialisationException {
        this.processorChain = new DefaultMessageProcessorChainBuilder().chain(this.processors).build();
        LifecycleUtils.initialiseIfNeeded(this.processorChain, this.muleContext);
        this.notificationHelper = new PolicyNotificationHelper(this.muleContext.getNotificationManager(), this.muleContext.getConfiguration().getId(), this);
    }

    @Override
    public void start() throws MuleException {
        if (this.processorChain != null) {
            this.processorChain.start();
        }
    }

    @Override
    public void dispose() {
        if (this.processorChain != null) {
            this.processorChain.dispose();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.processorChain != null) {
            this.processorChain.stop();
        }
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return this.processorChain.process(event);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Mono.from(publisher).doOnNext(this.notificationHelper.notification(2101)).transform((Function)this.processorChain).doOnSuccess(this.notificationHelper.notification(2104)).doOnError(MessagingException.class, this.notificationHelper.errorNotification(2104));
    }
}

