/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

abstract class AbstractEventContext
implements BaseEventContext {
    private static final int STATE_READY = 0;
    private static final int STATE_RESPONSE = 1;
    private static final int STATE_COMPLETE = 2;
    private static final int STATE_TERMINATED = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventContext.class);
    private static final FlowExceptionHandler NULL_EXCEPTION_HANDLER = NullExceptionHandler.getInstance();
    private final transient List<BaseEventContext> childContexts = new ArrayList<BaseEventContext>();
    private final transient FlowExceptionHandler exceptionHandler;
    private final transient CompletableFuture externalCompletion;
    private final transient List<BiConsumer<CoreEvent, Throwable>> onResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private final transient List<BiConsumer<CoreEvent, Throwable>> onCompletionConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private final transient List<BiConsumer<CoreEvent, Throwable>> onTerminatedConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private volatile int state = 0;
    private volatile Either<Throwable, CoreEvent> result;

    public AbstractEventContext() {
        this(NULL_EXCEPTION_HANDLER, Optional.empty());
    }

    public AbstractEventContext(FlowExceptionHandler exceptionHandler) {
        this(exceptionHandler, Optional.empty());
    }

    public AbstractEventContext(FlowExceptionHandler exceptionHandler, Optional<CompletableFuture<Void>> externalCompletion) {
        this.externalCompletion = externalCompletion.orElse(null);
        externalCompletion.ifPresent(completableFuture -> completableFuture.thenAccept(aVoid -> this.tryTerminate()));
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildContext(BaseEventContext childContext) {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            this.childContexts.add(childContext);
        }
    }

    @Override
    public final void success() {
        if (this.isResponseDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " empty response was already completed, ignoring.");
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " response completed with no result.");
        }
        this.responseDone(Either.right(null));
    }

    @Override
    public final void success(CoreEvent event) {
        if (this.isResponseDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response was already completed, ignoring.");
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " response completed with result.");
        }
        this.responseDone(Either.right(event));
    }

    @Override
    public final Publisher<Void> error(Throwable throwable) {
        if (this.isResponseDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " error response was already completed, ignoring.");
            }
            return Mono.empty();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " responseDone completed with error.");
        }
        if (throwable instanceof MessagingException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " handling messaging exception.");
            }
            return Mono.just((Object)((MessagingException)throwable)).flatMapMany((Function)this.exceptionHandler).doOnNext(handled -> this.success((CoreEvent)handled)).doOnError(rethrown -> this.responseDone(Either.left(rethrown))).materialize().then().toProcessor();
        }
        this.responseDone(Either.left(throwable));
        return Mono.empty();
    }

    private synchronized void responseDone(Either<Throwable, CoreEvent> result) {
        this.result = result;
        this.state = 1;
        this.tryComplete();
        this.onResponseConsumerList.stream().forEach(consumer -> this.signalConsumerSilently((BiConsumer<CoreEvent, Throwable>)consumer));
    }

    protected synchronized void tryComplete() {
        if (this.state == 1 && this.childContexts.stream().noneMatch(context -> !context.isComplete())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " completed.");
            }
            this.state = 2;
            this.onCompletionConsumerList.forEach(consumer -> this.signalConsumerSilently((BiConsumer<CoreEvent, Throwable>)consumer));
            this.getParentContext().ifPresent(context -> {
                if (context instanceof AbstractEventContext) {
                    ((AbstractEventContext)context).tryComplete();
                }
            });
            this.tryTerminate();
        }
    }

    protected synchronized void tryTerminate() {
        if (this.state == 2 && (this.externalCompletion == null || this.externalCompletion.isDone())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " terminated.");
            }
            this.state = 3;
            this.onTerminatedConsumerList.forEach(consumer -> this.signalConsumerSilently((BiConsumer<CoreEvent, Throwable>)consumer));
        }
    }

    private void signalConsumerSilently(BiConsumer<CoreEvent, Throwable> consumer) {
        try {
            consumer.accept(this.result.getRight(), this.result.getLeft());
        }
        catch (Throwable t) {
            LOGGER.error("The event consumer {}, of EventContext {} failed with exception: {} ", new Object[]{consumer, this, t});
        }
    }

    @Override
    public BaseEventContext getRootContext() {
        return this.getParentContext().map(BaseEventContext::getRootContext).orElse(this);
    }

    protected FlowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private boolean isResponseDone() {
        return this.state >= 1;
    }

    @Override
    public boolean isComplete() {
        return this.state >= 2;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 3;
    }

    @Override
    public synchronized void onTerminated(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 3) {
            this.signalConsumerSilently(consumer);
        }
        this.onTerminatedConsumerList.add(Objects.requireNonNull(consumer));
    }

    @Override
    public synchronized void onComplete(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 2) {
            this.signalConsumerSilently(consumer);
        }
        this.onCompletionConsumerList.add(Objects.requireNonNull(consumer));
    }

    @Override
    public synchronized void onResponse(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 1) {
            this.signalConsumerSilently(consumer);
        }
        this.onResponseConsumerList.add(Objects.requireNonNull(consumer));
    }

    @Override
    public Publisher<CoreEvent> getResponsePublisher() {
        return Mono.create(sink -> {
            if (this.isResponseDone()) {
                this.signalPublisherSink((MonoSink<CoreEvent>)sink);
            } else {
                AbstractEventContext abstractEventContext = this;
                synchronized (abstractEventContext) {
                    if (this.isResponseDone()) {
                        this.signalPublisherSink((MonoSink<CoreEvent>)sink);
                    } else {
                        this.onResponse((event, throwable) -> this.signalPublisherSink((MonoSink<CoreEvent>)sink));
                    }
                }
            }
        });
    }

    private void signalPublisherSink(MonoSink<CoreEvent> sink) {
        if (this.result.isLeft()) {
            sink.error(this.result.getLeft());
        } else {
            sink.success((Object)this.result.getRight());
        }
    }
}

