/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.value;

import java.util.Set;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.core.internal.value.MuleValueProviderServiceUtility;
import org.mule.runtime.extension.api.values.ComponentValueProvider;
import org.mule.runtime.extension.api.values.ConfigurationParameterValueProvider;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class MuleValueProviderService
implements ValueProviderService {
    @Inject
    private ConfigurationComponentLocator componentLocator;

    @Override
    public ValueResult getValues(Location location, String providerName) {
        return this.getValueResult(() -> this.findValueProvider(location, providerName).resolve());
    }

    private ValueResult getValueResult(ValueResultSupplier valueSupplier) {
        ValueResult result;
        try {
            result = ValueResult.resultFrom(valueSupplier.get());
        }
        catch (ValueResolvingException e) {
            ResolvingFailure failure = ResolvingFailure.Builder.newFailure(e).withFailureCode(e.getFailureCode()).build();
            result = ValueResult.resultFrom(failure);
        }
        catch (Exception e) {
            result = ValueResult.resultFrom(ResolvingFailure.Builder.newFailure(e).build());
        }
        return result;
    }

    private ValueProvider findValueProvider(Location location, String providerName) throws ValueResolvingException {
        Object component;
        boolean isConnection = MuleValueProviderServiceUtility.isConnection(location);
        if (isConnection) {
            location = MuleValueProviderServiceUtility.deleteLastPartFromLocation(location);
        }
        if ((component = this.findComponent(location)) instanceof ComponentValueProvider) {
            return () -> ((ComponentValueProvider)component).getValues(providerName);
        }
        if (component instanceof ConfigurationParameterValueProvider) {
            if (isConnection) {
                return () -> ((ConfigurationParameterValueProvider)component).getConnectionValues(providerName);
            }
            return () -> ((ConfigurationParameterValueProvider)component).getConfigValues(providerName);
        }
        throw new ValueResolvingException(String.format("The found element in the Location [%s] is not capable of provide Values", location), "NOT_VALUE_PROVIDER_ENABLED");
    }

    private Object findComponent(Location location) throws ValueResolvingException {
        return this.componentLocator.find(location).orElseThrow(() -> new ValueResolvingException(String.format("Invalid location [%s]. No element found in the given location.", location), "INVALID_LOCATION"));
    }

    @FunctionalInterface
    private static interface ValueResultSupplier {
        public Set<Value> get() throws Exception;
    }
}

