/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.util;

import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.type.DynamicConfigExpirationTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.PoolingProfileTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.ReconnectionStrategyTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.RedeliveryPolicyTypeBuilder;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.util.XmlModelUtils;

public final class InfrastructureParameterBuilder {
    private InfrastructureParameterBuilder() {
    }

    public static void addReconnectionConfigParameter(ParameterizedDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration("reconnection");
        parameter.setDescription("When the application is deployed, a connectivity test is performed on all connectors. If set to true, deployment will fail if the test doesn't pass after exhausting the associated reconnection strategy");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(new ReconnectionStrategyTypeBuilder().buildReconnectionConfigType(), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_DEFAULT_RECONNECTION_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 3);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }

    public static void addReconnectionStrategyParameter(ParameterizedDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration("reconnectionStrategy");
        parameter.setDescription("A retry strategy in case of connectivity errors");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(new ReconnectionStrategyTypeBuilder().buildReconnectionStrategyType(), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_RECONNECTION_STRATEGY_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 3);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }

    public static void addPoolingProfileParameter(ConnectionProviderDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration("poolingProfile");
        parameter.setDescription("Characteristics of the connection pool");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(new PoolingProfileTypeBuilder().buildPoolingProfileType(), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_POOLING_PROFILE_TYPE_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 5);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }

    public static void addRedeliveryPolicy(ParameterizedDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration("redeliveryPolicy");
        parameter.setDescription("Defines a policy for processing the redelivery of the same message");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(new RedeliveryPolicyTypeBuilder().buildRedeliveryPolicyType(), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Redelivery").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_REDELIVERY_POLICY_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 1);
        declaration.getParameterGroup("General").addParameter(parameter);
    }

    public static ParameterDeclaration addStreamingParameter(ComponentDeclaration declaration, MetadataType type, QName qName) {
        ParameterDeclaration parameter = new ParameterDeclaration("streamingStrategy");
        parameter.setDescription("Configure if repeatable streams should be used and their behaviour");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(type, false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(qName));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 2);
        declaration.getParameterGroup("General").addParameter(parameter);
        return parameter;
    }

    public static ParameterDeclaration addExpirationPolicy(ConfigurationDeclaration config) {
        ParameterDeclaration parameter = new ParameterDeclaration("expirationPolicy");
        parameter.setDescription("Configures the minimum amount of time that a dynamic configuration instance can remain idle before the runtime considers it eligible for expiration. This does not mean that the platform will expire the instance at the exact moment that it becomes eligible. The runtime will actually purge the instances when it sees it fit.");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(new DynamicConfigExpirationTypeBuilder().buildExpirationPolicyType(), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_EXPIRATION_POLICY_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 4);
        config.getParameterGroup("General").addParameter(parameter);
        return parameter;
    }

    public static void markAsInfrastructure(ParameterDeclaration parameter, int sequence) {
        parameter.addModelProperty(new InfrastructureParameterModelProperty(sequence));
    }
}

