/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultMuleDomain;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.EmptyDomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.service.api.manager.ServiceRepository;

public class DefaultDomainFactory
implements ArtifactFactory<Domain> {
    private final DomainManager domainManager;
    private final DomainDescriptorFactory domainDescriptorFactory;
    private final ClassLoaderRepository classLoaderRepository;
    private final ServiceRepository serviceRepository;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private ExtensionModelLoaderManager extensionModelLoaderManager;

    public DefaultDomainFactory(DomainDescriptorFactory domainDescriptorFactory, DomainManager domainManager, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository, PluginDependenciesResolver pluginDependenciesResolver, DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory, ExtensionModelLoaderManager extensionModelLoaderManager) {
        Preconditions.checkArgument(domainDescriptorFactory != null, "domainDescriptorFactory cannot be null");
        Preconditions.checkArgument(domainManager != null, "Domain manager cannot be null");
        Preconditions.checkArgument(serviceRepository != null, "Service repository cannot be null");
        Preconditions.checkArgument(pluginDependenciesResolver != null, "pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument(domainClassLoaderBuilderFactory != null, "domainClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument(extensionModelLoaderManager != null, "extensionModelLoaderManager cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.domainDescriptorFactory = domainDescriptorFactory;
        this.domainManager = domainManager;
        this.serviceRepository = serviceRepository;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.domainClassLoaderBuilderFactory = domainClassLoaderBuilderFactory;
        this.extensionModelLoaderManager = extensionModelLoaderManager;
    }

    public Domain createArtitact(DomainDescriptor descriptor) throws IOException {
        List<ArtifactPluginDescriptor> artifactPluginDescriptors = descriptor.getPlugins().stream().collect(Collectors.toList());
        List<ArtifactPluginDescriptor> resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(artifactPluginDescriptors);
        DomainClassLoaderBuilder artifactClassLoaderBuilder = this.domainClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader domainClassLoader = ((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)artifactClassLoaderBuilder.addArtifactPluginDescriptors(resolvedArtifactPluginDescriptors.toArray(new ArtifactPluginDescriptor[0]))).setArtifactId(descriptor.getName())).setArtifactDescriptor(descriptor)).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(domainClassLoader, resolvedArtifactPluginDescriptors);
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(descriptor, domainClassLoader, this.classLoaderRepository, this.serviceRepository, artifactPlugins, this.extensionModelLoaderManager);
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domainManager.addDomain(domainWrapper);
        return domainWrapper;
    }

    private DomainDescriptor findDomain(String domainName, Optional<Properties> deploymentProperties) throws IOException {
        if ("default".equals(domainName)) {
            return new EmptyDomainDescriptor(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), "default"));
        }
        File domainFolder = MuleFoldersUtil.getDomainFolder(domainName);
        DomainDescriptor descriptor = (DomainDescriptor)this.domainDescriptorFactory.create(domainFolder, deploymentProperties);
        return descriptor;
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader domainClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId(domainClassLoader.getArtifactId(), artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, domainClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domainManager.removeDomain(domain.getArtifactName());
    }

    public void start(DomainWrapper domainWrapper) {
        this.domainManager.addDomain(domainWrapper);
    }

    @Override
    public Domain createArtifact(File domainLocation, Optional<Properties> deploymentProperties) throws IOException {
        String domainName = domainLocation.getName();
        Domain domain = this.domainManager.getDomain(domainName);
        if (domain != null) {
            throw new IllegalArgumentException(String.format("Domain '%s'  already exists", domainName));
        }
        if (domainName.contains(" ")) {
            throw new IllegalArgumentException("Mule domain name may not contain spaces: " + domainName);
        }
        return this.createArtitact(this.findDomain(domainName, deploymentProperties));
    }
}

