/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.ParameterDescriptionDocumenter;

final class SourcesDescriptionDocumenter
extends AbstractDescriptionDocumenter<WithSourcesDeclaration<?>> {
    private final ParameterDescriptionDocumenter parameterDeclarer;

    SourcesDescriptionDocumenter(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.parameterDeclarer = new ParameterDescriptionDocumenter(processingEnv);
    }

    @Override
    void document(WithSourcesDeclaration<?> declaration, TypeElement element) {
        this.getSourceClasses(this.processingEnv, element).forEach(sourceElement -> this.findMatchingSource(declaration, (Element)sourceElement).ifPresent(source -> {
            source.setDescription(processor.getJavaDocSummary(this.processingEnv, (Element)sourceElement));
            this.parameterDeclarer.document((ParameterizedDeclaration<?>)source, (TypeElement)sourceElement);
        }));
    }

    private Optional<SourceDeclaration> findMatchingSource(WithSourcesDeclaration<?> declaration, Element element) {
        return declaration.getMessageSources().stream().filter(provider -> {
            String name = provider.getName();
            String alias = this.getAliasValue(element);
            String defaultNaming = NameUtils.hyphenize(element.getSimpleName().toString());
            return name.equals(defaultNaming) || name.equals(alias);
        }).findAny();
    }

    private List<TypeElement> getSourceClasses(ProcessingEnvironment processingEnv, Element element) {
        Sources sourcesAnnotation = (Sources)processor.getAnnotationFromType(processingEnv, (TypeElement)element, Sources.class);
        if (sourcesAnnotation == null) {
            return Collections.emptyList();
        }
        return processor.getAnnotationClassesValue(element, Sources.class, sourcesAnnotation.value());
    }
}

