/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Type;
import java.util.List;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.java.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.FunctionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAlias;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.type.WithParameters;
import org.springframework.core.ResolvableType;

abstract class AbstractModelLoaderDelegate {
    protected final DefaultJavaModelLoaderDelegate loader;

    AbstractModelLoaderDelegate(DefaultJavaModelLoaderDelegate loader) {
        this.loader = loader;
    }

    protected Class<?> getExtensionType() {
        return this.loader.getExtensionType();
    }

    ConfigModelLoaderDelegate getConfigLoaderDelegate() {
        return this.loader.getConfigLoaderDelegate();
    }

    OperationModelLoaderDelegate getOperationModelLoaderDelegate() {
        return this.loader.getOperationLoaderDelegate();
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.loader.getSourceModelLoaderDelegate();
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.loader.getConnectionProviderModelLoaderDelegate();
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.loader.getOperationLoaderDelegate();
    }

    FunctionModelLoaderDelegate getFunctionModelLoaderDelegate() {
        return this.loader.getFunctionModelLoaderDelegate();
    }

    ClassTypeLoader getTypeLoader() {
        return this.loader.getTypeLoader();
    }

    void processComponentConnectivity(ExecutableComponentDeclarer componentDeclarer, WithParameters component, WithAlias alias) {
        List<ExtensionParameter> connectionParameters = component.getParametersAnnotatedWith(Connection.class);
        if (connectionParameters.isEmpty()) {
            ((ExecutableComponentDeclarer)componentDeclarer.requiresConnection(false)).transactional(false);
        } else if (connectionParameters.size() == 1) {
            ExtensionParameter connectionParameter = connectionParameters.iterator().next();
            Class<?> connectionType = this.resolveConnectionType(componentDeclarer, connectionParameter, alias);
            ((ComponentDeclarer)((ExecutableComponentDeclarer)componentDeclarer.requiresConnection(true)).transactional(TransactionalConnection.class.isAssignableFrom(connectionType))).withModelProperty(new ConnectivityModelProperty(connectionType));
        } else if (connectionParameters.size() > 1) {
            throw new IllegalOperationModelDefinitionException(String.format("%s '%s' defines %d parameters annotated with @%s. Only one is allowed", NameUtils.getComponentDeclarationTypeName(componentDeclarer.getDeclaration()), alias.getAlias(), connectionParameters.size(), Connection.class.getSimpleName()));
        }
    }

    private Class<?> resolveConnectionType(ExecutableComponentDeclarer componentDeclarer, ExtensionParameter connectionParameter, WithAlias alias) {
        Type type = connectionParameter.getJavaType();
        if (type.getTypeName().startsWith(ConnectionProvider.class.getName())) {
            ResolvableType resolvableType = ResolvableType.forType((Type)type);
            if (resolvableType.getGenerics().length == 0) {
                throw new IllegalOperationModelDefinitionException(String.format("%s '%s' defines a %s without a connection type. Please add the generic", NameUtils.getComponentDeclarationTypeName(componentDeclarer.getDeclaration()), alias.getAlias(), ConnectionProvider.class.getSimpleName()));
            }
            return resolvableType.getGeneric(new int[]{0}).getRawClass();
        }
        return connectionParameter.getType().getDeclaringClass();
    }

    void processMimeType(HasModelProperties declarer, WithAnnotations element) {
        element.getAnnotation(MediaType.class).ifPresent(a -> declarer.withModelProperty(new MediaTypeModelProperty(a.value(), a.strict())));
    }
}

