/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.config.ExpirableConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicConfigurationProvider
extends LifecycleAwareConfigurationProvider
implements ExpirableConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicConfigurationProvider.class);
    private final ConfigurationInstanceFactory configurationInstanceFactory;
    private final ResolverSet resolverSet;
    private final ConnectionProviderValueResolver connectionProviderResolver;
    private final ExpirationPolicy expirationPolicy;
    private final Map<Pair<ResolverSetResult, ResolverSetResult>, ConfigurationInstance> cache = new ConcurrentHashMap<Pair<ResolverSetResult, ResolverSetResult>, ConfigurationInstance>();
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock cacheReadLock = this.cacheLock.readLock();
    private final Lock cacheWriteLock = this.cacheLock.writeLock();

    public DynamicConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, ConnectionProviderValueResolver connectionProviderResolver, ExpirationPolicy expirationPolicy, MuleContext muleContext) {
        super(name, extensionModel, configurationModel, muleContext);
        this.configurationInstanceFactory = new ConfigurationInstanceFactory(extensionModel, configurationModel, resolverSet, muleContext);
        this.resolverSet = resolverSet;
        this.connectionProviderResolver = connectionProviderResolver;
        this.expirationPolicy = expirationPolicy;
    }

    @Override
    public ConfigurationInstance get(Event event) {
        return ClassUtils.withContextClassLoader(this.getExtensionClassLoader(), () -> {
            ResolverSetResult result = this.resolverSet.resolve(ValueResolvingContext.from((CoreEvent)event));
            ResolverSetResult providerResult = null;
            if (this.connectionProviderResolver.getResolverSet().isPresent()) {
                providerResult = this.connectionProviderResolver.getResolverSet().get().resolve(ValueResolvingContext.from((CoreEvent)event));
            }
            return this.getConfiguration(new Pair<ResolverSetResult, Object>(result, providerResult), (CoreEvent)event);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationInstance getConfiguration(Pair<ResolverSetResult, ResolverSetResult> resolverSetResult, CoreEvent event) throws Exception {
        ConfigurationInstance configuration;
        this.cacheReadLock.lock();
        try {
            configuration = this.cache.get(resolverSetResult);
            if (configuration != null) {
                this.updateUsageStatistic(configuration);
                ConfigurationInstance configurationInstance = configuration;
                return configurationInstance;
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        this.cacheWriteLock.lock();
        try {
            configuration = this.cache.get(resolverSetResult);
            if (configuration == null) {
                configuration = this.createConfiguration(resolverSetResult, event);
                this.cache.put(resolverSetResult, configuration);
            }
            this.updateUsageStatistic(configuration);
            ConfigurationInstance configurationInstance = configuration;
            return configurationInstance;
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private void updateUsageStatistic(ConfigurationInstance configuration) {
        MutableConfigurationStats stats = (MutableConfigurationStats)configuration.getStatistics();
        stats.updateLastUsed();
    }

    private ConfigurationInstance createConfiguration(Pair<ResolverSetResult, ResolverSetResult> values, CoreEvent event) throws MuleException {
        ResolverSetResult connectionProviderValues = values.getSecond();
        ConfigurationInstance configuration = connectionProviderValues != null ? this.configurationInstanceFactory.createConfiguration(this.getName(), values.getFirst(), event, this.connectionProviderResolver, connectionProviderValues) : this.configurationInstanceFactory.createConfiguration(this.getName(), values.getFirst(), event, Optional.ofNullable(this.connectionProviderResolver));
        this.registerConfiguration(configuration);
        return configuration;
    }

    @Override
    protected void registerConfiguration(ConfigurationInstance configuration) {
        try {
            ClassUtils.withContextClassLoader(this.getExtensionClassLoader(), () -> {
                if (this.lifecycleManager.isPhaseComplete("initialise")) {
                    try {
                        LifecycleUtils.initialiseIfNeeded(configuration, true, this.muleContext);
                    }
                    catch (Exception e) {
                        LifecycleUtils.disposeIfNeeded(configuration, LOGGER);
                        throw e;
                    }
                }
                if (this.lifecycleManager.isPhaseComplete("start")) {
                    try {
                        this.startConfig(configuration);
                    }
                    catch (Exception e) {
                        try {
                            LifecycleUtils.stopIfNeeded(configuration);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Exception while stopping " + configuration.toString(), (Throwable)e);
                        }
                        LifecycleUtils.disposeIfNeeded(configuration, LOGGER);
                        throw e;
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not register configuration of key " + this.getName()), (Throwable)e);
        }
        super.registerConfiguration(configuration);
    }

    @Override
    public List<ConfigurationInstance> getExpired() {
        this.cacheWriteLock.lock();
        try {
            List<ConfigurationInstance> list = this.cache.entrySet().stream().filter(entry -> this.isExpired((ConfigurationInstance)entry.getValue())).map(entry -> {
                this.cache.remove(entry.getKey());
                return (ConfigurationInstance)entry.getValue();
            }).collect(Collectors.toImmutableList());
            return list;
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private boolean isExpired(ConfigurationInstance configuration) {
        ConfigurationStats stats = configuration.getStatistics();
        return stats.getInflightOperations() == 0 && this.expirationPolicy.isExpired(stats.getLastUsedMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doInitialise() {
        try {
            LifecycleUtils.initialiseIfNeeded(this.resolverSet, this.muleContext);
            LifecycleUtils.initialiseIfNeeded(this.connectionProviderResolver, this.muleContext);
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        LifecycleUtils.startIfNeeded(this.connectionProviderResolver);
    }
}

