/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.config.ConfigurationInstanceNotification;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.config.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.loader.AbstractInterceptable;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultMutableConfigurationStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LifecycleAwareConfigurationInstance
extends AbstractInterceptable
implements ConfigurationInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleAwareConfigurationInstance.class);
    private static final String DO_TEST_CONNECTIVITY_PROPERTY_NAME = "doTestConnectivity";
    private final String name;
    private final ConfigurationModel model;
    private final Object value;
    private final ConfigurationState configurationState;
    private final Optional<ConnectionProvider> connectionProvider;
    private ConfigurationStats configurationStats;
    @Inject
    private TimeSupplier timeSupplier;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private NotificationDispatcher notificationFirer;
    @Inject
    private ConnectionManagerAdapter connectionManager;
    private volatile Lock testConnectivityLock;
    private Scheduler retryScheduler;
    private volatile boolean initialized = false;
    private volatile boolean started = false;
    private boolean doTestConnectivity = this.getDoTestConnectivityProperty();

    public LifecycleAwareConfigurationInstance(String name, ConfigurationModel model, Object value, ConfigurationState configurationState, List<Interceptor> interceptors, Optional<ConnectionProvider> connectionProvider) {
        super(interceptors);
        this.name = name;
        this.model = model;
        this.value = value;
        this.configurationState = configurationState;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public synchronized void initialise() throws InitialisationException {
        if (!this.initialized) {
            this.initialized = true;
            this.testConnectivityLock = this.lockFactory.createLock(this.getClass().getName() + "-testConnectivity-" + this.getName());
            try {
                this.initStats();
                this.doInitialise();
                super.initialise();
            }
            catch (Exception e) {
                if (e instanceof InitialisationException) {
                    throw (InitialisationException)e;
                }
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    @Override
    public synchronized void start() throws MuleException {
        if (!this.started) {
            this.started = true;
            if (this.connectionProvider.isPresent()) {
                LifecycleUtils.startIfNeeded(this.connectionProvider);
                if (!this.connectionManager.hasBinding(this.value)) {
                    this.connectionManager.bind(this.value, this.connectionProvider.get());
                }
                if (this.doTestConnectivity) {
                    this.testConnectivity();
                }
            }
            LifecycleUtils.startIfNeeded(this.value);
            super.start();
        }
    }

    private void testConnectivity() throws MuleException {
        ConnectionProvider provider = this.connectionProvider.get();
        if (provider instanceof NoConnectivityTest) {
            return;
        }
        RetryPolicyTemplate retryTemplate = this.connectionManager.getRetryTemplateFor(provider);
        final ReconnectionConfig reconnectionConfig = this.connectionManager.getReconnectionConfigFor(provider);
        RetryCallback retryCallback = new RetryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void doWork(RetryContext context) throws Exception {
                Lock lock = LifecycleAwareConfigurationInstance.this.testConnectivityLock;
                if (lock == null) return;
                boolean lockAcquired = lock.tryLock();
                if (lockAcquired) {
                    LOGGER.info("Doing testConnectivity() for config " + LifecycleAwareConfigurationInstance.this.getName());
                    try {
                        ConnectionValidationResult result = LifecycleAwareConfigurationInstance.this.connectionManager.testConnectivity(LifecycleAwareConfigurationInstance.this);
                        if (result.isValid()) {
                            context.setOk();
                            return;
                        }
                        if (reconnectionConfig.isFailsDeployment()) {
                            context.setFailed(result.getException());
                            throw new ConnectionException(String.format("Connectivity test failed for config '%s'", LifecycleAwareConfigurationInstance.this.getName()), (Throwable)result.getException());
                        }
                        if (!LOGGER.isInfoEnabled()) return;
                        LOGGER.info(String.format("Connectivity test failed for config '%s'. Application deployment will continue. Error was: ", LifecycleAwareConfigurationInstance.this.getName(), result.getMessage()), (Throwable)result.getException());
                        return;
                    }
                    finally {
                        lock.unlock();
                    }
                } else {
                    LOGGER.warn("There is a testConnectivity() already running for config " + LifecycleAwareConfigurationInstance.this.getName());
                }
            }

            @Override
            public String getWorkDescription() {
                return String.format("Testing connectivity for config '%s'", LifecycleAwareConfigurationInstance.this.getName());
            }

            @Override
            public Object getWorkOwner() {
                return LifecycleAwareConfigurationInstance.this.value;
            }
        };
        try {
            retryTemplate.execute(retryCallback, this.retryScheduler);
        }
        catch (Exception e) {
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage(String.format("Could not perform connectivity testing for config '%s'", this.getName())), (Throwable)e);
        }
    }

    @Override
    public synchronized void stop() throws MuleException {
        if (this.started) {
            this.started = false;
            try {
                LifecycleUtils.stopIfNeeded(this.value);
                if (this.connectionProvider.isPresent()) {
                    this.testConnectivityLock.lock();
                    try {
                        this.connectionManager.unbind(this.value);
                        LifecycleUtils.stopIfNeeded(this.connectionProvider);
                    }
                    finally {
                        this.testConnectivityLock.unlock();
                    }
                }
                super.stop();
            }
            finally {
                this.notificationFirer.dispatch(new ConfigurationInstanceNotification(this, ConfigurationInstanceNotification.CONFIGURATION_STOPPED));
            }
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.initialized) {
            this.initialized = false;
            if (this.retryScheduler != null) {
                this.retryScheduler.stop();
            }
            LifecycleUtils.disposeIfNeeded(this.value, LOGGER);
            LifecycleUtils.disposeIfNeeded(this.connectionProvider, LOGGER);
            this.configurationStats = null;
            this.testConnectivityLock = null;
            super.dispose();
        }
    }

    private void doInitialise() throws InitialisationException {
        if (this.connectionProvider.isPresent()) {
            LifecycleUtils.initialiseIfNeeded(this.connectionProvider, true, this.muleContext);
            this.connectionManager.bind(this.value, this.connectionProvider.get());
        }
        LifecycleUtils.initialiseIfNeeded(this.value, true, this.muleContext);
        this.retryScheduler = this.schedulerService.ioScheduler();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<ConnectionProvider> getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public ConfigurationModel getModel() {
        return this.model;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public ConfigurationStats getStatistics() {
        Preconditions.checkState(this.configurationStats != null, "can't get statistics before initialise() is invoked");
        return this.configurationStats;
    }

    @Override
    public ConfigurationState getState() {
        return this.configurationState;
    }

    private void initStats() {
        if (this.timeSupplier == null) {
            this.timeSupplier = new LocalTimeSupplier();
        }
        this.configurationStats = new DefaultMutableConfigurationStats(this.timeSupplier);
    }

    private boolean getDoTestConnectivityProperty() {
        return System.getProperty(DO_TEST_CONNECTIVITY_PROPERTY_NAME) != null ? Boolean.valueOf(System.getProperty(DO_TEST_CONNECTIVITY_PROPERTY_NAME)) : true;
    }
}

